/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator;

import de.renew.navigator.NavigatorController;
import de.renew.navigator.NavigatorPlugin;
import de.renew.navigator.models.Directory;
import de.renew.navigator.models.DirectoryType;
import de.renew.navigator.models.Leaf;
import de.renew.navigator.models.Model;
import de.renew.navigator.models.SearchFilter;
import de.renew.navigator.models.TreeElement;
import de.renew.plugin.PluginManager;
import java.io.File;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AutosaveController
extends NavigatorController {
    private final DocumentBuilder documentBuilder;
    private final Transformer transformer;
    private final File autosaveFile = new File(PluginManager.getPreferencesLocation(), "navigator.xml");
    private SwingWorker<Document, Object> worker;
    public static final Logger logger = Logger.getLogger(AutosaveController.class);

    public AutosaveController(NavigatorPlugin navigatorPlugin) {
        super(navigatorPlugin);
        try {
            this.documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            this.transformer = TransformerFactory.newInstance().newTransformer();
            this.transformer.setOutputProperty("indent", "yes");
            this.transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException(parserConfigurationException);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new RuntimeException(transformerConfigurationException);
        }
    }

    @Override
    public void onModelChanged(Object object) {
        if (this.worker != null && !this.worker.isDone()) {
            logger.trace((Object)"Cancelled old worker.");
            this.worker.cancel(true);
        }
        this.worker = new SwingWorker<Document, Object>(){

            @Override
            protected Document doInBackground() throws Exception {
                return AutosaveController.this.createXmlDocument();
            }

            @Override
            protected void done() {
                if (this.isCancelled()) {
                    return;
                }
                try {
                    DOMSource dOMSource = new DOMSource((Node)this.get());
                    StreamResult streamResult = new StreamResult(AutosaveController.this.autosaveFile);
                    try {
                        AutosaveController.this.transformer.transform(dOMSource, streamResult);
                    }
                    catch (TransformerException transformerException) {
                        transformerException.printStackTrace();
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException executionException) {
                    logger.error((Object)"Could not create autosave XML file", (Throwable)executionException);
                }
            }
        };
        this.worker.execute();
    }

    public void loadModel() {
        this.model.clear();
        try {
            Object object;
            String[] stringArray;
            Object object2;
            Object object3;
            Element element;
            Document document = this.documentBuilder.parse(this.autosaveFile);
            document.getDocumentElement().normalize();
            Element element2 = document.getDocumentElement();
            this.model.setTextSearch(null);
            NodeList nodeList = element2.getElementsByTagName("text-search");
            if (nodeList.getLength() > 0) {
                element = (Element)nodeList.item(0);
                String string = element.getAttribute("name");
                object3 = SearchFilter.Type.valueOf(element.getAttribute("type"));
                boolean bl = Boolean.valueOf(element.getAttribute("case-sensitive"));
                object2 = element.getElementsByTagName("term");
                stringArray = new String[object2.getLength()];
                for (int i = 0; i < object2.getLength(); ++i) {
                    object = (Element)object2.item(i);
                    stringArray[i] = object.getTextContent();
                }
                SearchFilter searchFilter = new SearchFilter(string, (SearchFilter.Type)((Object)object3), bl, stringArray);
                this.model.setTextSearch(searchFilter);
            }
            element = (Element)element2.getElementsByTagName("filters").item(0);
            for (int i = 0; i < element.getChildNodes().getLength(); ++i) {
                object3 = element.getChildNodes().item(i);
                if (!(object3 instanceof Element)) continue;
                Element element3 = (Element)object3;
                object2 = element3.getAttribute("name");
                stringArray = SearchFilter.Type.valueOf(element3.getAttribute("type"));
                boolean bl = Boolean.valueOf(element3.getAttribute("case-sensitive"));
                object = element3.getElementsByTagName("term");
                String[] stringArray2 = new String[object.getLength()];
                for (int j = 0; j < object.getLength(); ++j) {
                    Element element4 = (Element)object.item(j);
                    stringArray2[j] = element4.getTextContent();
                }
                SearchFilter searchFilter = new SearchFilter((String)object2, (SearchFilter.Type)stringArray, bl, stringArray2);
                this.model.activateFileFilter(searchFilter);
            }
            Element element5 = (Element)element2.getElementsByTagName("trees").item(0);
            for (int i = 0; i < element5.getChildNodes().getLength(); ++i) {
                Node node = element5.getChildNodes().item(i);
                if (!(node instanceof Element)) continue;
                object2 = (Element)node;
                this.loadTreeElementFromXml(this.model, (Element)object2);
            }
            this.model.notifyObservers(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean isAutosaveFileExisting() {
        return this.autosaveFile.exists();
    }

    private Document createXmlDocument() {
        Element element;
        Document document = this.documentBuilder.newDocument();
        Element element2 = document.createElement("navigator");
        document.appendChild(element2);
        if (this.model.getTextSearch() != null) {
            element = document.createElement("text-search");
            element2.appendChild(element);
            this.saveSearchFilterToElement(this.model.getTextSearch(), element);
        }
        element = document.createElement("filters");
        element2.appendChild(element);
        for (SearchFilter object : this.model.getActiveFileFilters()) {
            Element element3 = document.createElement("filter");
            element.appendChild(element3);
            this.saveSearchFilterToElement(object, element3);
        }
        Element element3 = document.createElement("trees");
        element2.appendChild(element3);
        for (TreeElement treeElement : this.model.getTreeRoots()) {
            this.saveTreeElementToXml(treeElement, element3);
        }
        return document;
    }

    private void saveSearchFilterToElement(SearchFilter searchFilter, Element element) {
        element.setAttribute("name", searchFilter.getName());
        element.setAttribute("case-sensitive", String.valueOf(searchFilter.isCaseSensitive()));
        element.setAttribute("type", searchFilter.getType().toString());
        for (String string : searchFilter.getTerms()) {
            Element element2 = element.getOwnerDocument().createElement("term");
            element.appendChild(element2);
            element2.setTextContent(string);
        }
    }

    private void saveTreeElementToXml(TreeElement treeElement, Element element) {
        String string = this.treeElementToName(treeElement);
        Element element2 = element.getOwnerDocument().createElement(string);
        element.appendChild(element2);
        element2.setAttribute("name", treeElement.getName());
        element2.setAttribute("excluded", String.valueOf(treeElement.isExcluded()));
        element2.setAttribute("file", treeElement.getFile().toString());
        if (treeElement instanceof Directory) {
            Directory directory = (Directory)treeElement;
            element2.setAttribute("opened", String.valueOf(directory.isOpened()));
            if (directory.getType() != null) {
                element2.setAttribute("type", directory.getType().toString());
            }
            for (TreeElement treeElement2 : directory.getChildren()) {
                this.saveTreeElementToXml(treeElement2, element2);
            }
        }
    }

    private void loadTreeElementFromXml(Model model, Element element) {
        TreeElement treeElement = this.nameToTreeElement(element.getTagName());
        model.add(treeElement);
        treeElement.setName(element.getAttribute("name"));
        treeElement.setExcluded(Boolean.valueOf(element.getAttribute("excluded")));
        treeElement.setFile(new File(element.getAttribute("file")));
        if (treeElement instanceof Directory) {
            Directory directory = (Directory)treeElement;
            directory.setOpened(Boolean.valueOf(element.getAttribute("opened")));
            if (element.hasAttribute("type")) {
                directory.setType(DirectoryType.valueOf(element.getAttribute("type")));
            } else {
                directory.setType(null);
            }
            for (int i = 0; i < element.getChildNodes().getLength(); ++i) {
                Node node = element.getChildNodes().item(i);
                if (!(node instanceof Element)) continue;
                this.loadTreeElementFromXml(directory, (Element)node);
            }
        }
    }

    private TreeElement nameToTreeElement(String string) {
        if (string.equals("file")) {
            return new Leaf();
        }
        return new Directory();
    }

    private String treeElementToName(TreeElement treeElement) {
        Class<?> clazz = treeElement.getClass();
        if (clazz.equals(Leaf.class)) {
            return "file";
        }
        return "directory";
    }
}

