/*
 * Decompiled with CFR 0.152.
 */
package de.renew.console.completer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import jline.console.completer.Completer;
import jline.internal.Preconditions;

public class CompleterComposition
implements Completer {
    private final List<Completer> completers = new ArrayList<Completer>();

    public CompleterComposition() {
    }

    public CompleterComposition(Collection<Completer> collection) {
        Preconditions.checkNotNull(collection);
        this.completers.addAll(collection);
    }

    public CompleterComposition(Completer ... completerArray) {
        this(Arrays.asList(completerArray));
    }

    public Collection<Completer> getCompleters() {
        return this.completers;
    }

    public int complete(String string, int n, List<CharSequence> list) {
        Preconditions.checkNotNull(list);
        ArrayList<Completion> arrayList = new ArrayList<Completion>(this.completers.size());
        int n2 = -1;
        for (Completer object : this.completers) {
            Completion completion = new Completion(list);
            completion.complete(object, string, n);
            n2 = Math.max(n2, completion.cursor);
            arrayList.add(completion);
        }
        for (Completion completion : arrayList) {
            if (completion.cursor != n2) continue;
            list.addAll(completion.candidates);
        }
        return n2;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{completers=" + String.valueOf(this.completers) + "}";
    }

    public void addCompleter(Completer completer) {
        this.completers.add(completer);
    }

    public void removeCompleter(Completer completer) {
        this.completers.remove(completer);
    }

    private class Completion {
        public final List<CharSequence> candidates;
        public int cursor;

        public Completion(List<CharSequence> list) {
            Preconditions.checkNotNull(list);
            this.candidates = new LinkedList<CharSequence>(list);
        }

        public void complete(Completer completer, String string, int n) {
            Preconditions.checkNotNull((Object)completer);
            this.cursor = completer.complete(string, n, this.candidates);
        }
    }
}

