/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.pnml.creator;

import de.renew.gui.CPNDrawing;
import de.renew.gui.PlaceFigure;
import de.renew.gui.pnml.creator.NetCreator;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;

public class PNMLCreator {
    public static Logger logger = Logger.getLogger(PNMLCreator.class);
    private static String xmlNamespace = "http://www.pnml.org/version-2009/grammar/pnml";
    private String _netType;
    private boolean _toolInsc;
    private Document _doc;

    public PNMLCreator(String string, boolean bl) {
        this._netType = string;
        this._toolInsc = bl;
    }

    private static Transformer createTransformer() {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "3");
            return transformer;
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new RuntimeException(transformerConfigurationException);
        }
    }

    public List<PlaceFigure> setDrawings(CPNDrawing cPNDrawing) throws ParserConfigurationException {
        this.makeDoc();
        return this.addNet(cPNDrawing);
    }

    private void setDrawings(CPNDrawing[] cPNDrawingArray) throws ParserConfigurationException {
        this.makeDoc();
        for (int i = 0; i < cPNDrawingArray.length; ++i) {
            this.addNet(cPNDrawingArray[i]);
        }
    }

    public void write(OutputStream outputStream, CPNDrawing cPNDrawing) throws Exception {
        this.setDrawings(cPNDrawing);
        this.writeXML(outputStream);
    }

    public void write(OutputStream outputStream, CPNDrawing[] cPNDrawingArray) throws Exception {
        this.setDrawings(cPNDrawingArray);
        this.writeXML(outputStream);
    }

    private void makeDoc() throws ParserConfigurationException {
        DOMImplementation dOMImplementation = DocumentBuilderFactory.newInstance().newDocumentBuilder().getDOMImplementation();
        DocumentType documentType = dOMImplementation.createDocumentType("PNMLFile", null, null);
        this._doc = dOMImplementation.createDocument(xmlNamespace, "pnml", documentType);
    }

    private List<PlaceFigure> addNet(CPNDrawing cPNDrawing) {
        Element element = this._doc.getDocumentElement();
        NetCreator netCreator = new NetCreator(this._netType, this._toolInsc);
        element.appendChild(netCreator.createElement(this, cPNDrawing));
        return netCreator.getPlaceList();
    }

    private void writeXML(OutputStream outputStream) {
        Transformer transformer = PNMLCreator.createTransformer();
        DOMSource dOMSource = new DOMSource(this._doc);
        StreamResult streamResult = new StreamResult(outputStream);
        try {
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerException transformerException) {
            logger.error((Object)(PNMLCreator.class.getSimpleName() + ": " + transformerException.getLocalizedMessage()), (Throwable)transformerException);
        }
        try {
            outputStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Element createElement(String string) {
        return this._doc.createElement(string);
    }

    public Element createToolspecific() {
        Element element = this.createElement("toolspecific");
        element.setAttribute("tool", "renew");
        element.setAttribute("version", "2.0");
        return element;
    }

    public Element createTextElement(String string) {
        Element element = this.createElement("text");
        element.appendChild(this._doc.createTextNode(string));
        return element;
    }

    public Element getDocumentElement() {
        return this._doc.getDocumentElement();
    }
}

