/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.figures.FigureAttributes;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.ChildFigure;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.framework.ParentFigure;
import CH.ifa.draw.standard.AbstractFigure;
import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.standard.MergedFigureEnumerator;
import CH.ifa.draw.standard.NullHandle;
import CH.ifa.draw.standard.OffsetLocator;
import CH.ifa.draw.standard.RelativeLocator;
import CH.ifa.draw.util.AWTSynchronizedUpdate;
import de.renew.gui.MultipleTokenFigure;
import de.renew.gui.SimpleCompositeFigure;
import de.renew.remote.EventListener;
import de.renew.remote.MarkingAccessor;
import de.renew.remote.ObjectAccessor;
import de.renew.remote.PlaceInstanceAccessor;
import de.renew.remote.RemoteEventForwarder;
import de.renew.remote.RemoteEventListener;
import de.renew.remote.TokenCountsAccessor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.log4j.Logger;

public class TokenBagFigure
extends SimpleCompositeFigure
implements ChildFigure,
EventListener {
    public static Logger logger = Logger.getLogger(TokenBagFigure.class);
    private static final int BORDER = 3;
    private static final int SEPARATOR = 1;
    private OffsetLocator fLocator = null;
    private Drawing lockDrawing;
    private AbstractFigure figure;
    private PlaceInstanceAccessor placeInstance;
    private RemoteEventForwarder forwarder;
    private int cacheMult = -1;
    private int cacheTestMult = -1;
    private TextFigure cardFigure;
    private FigureAttributes attributes;
    private int markingAppearance = -1;
    private AWTSynchronizedUpdate updateTask = null;

    public TokenBagFigure() {
    }

    public TokenBagFigure(Drawing drawing, AbstractFigure abstractFigure, PlaceInstanceAccessor placeInstanceAccessor) {
        this(drawing, abstractFigure, placeInstanceAccessor, 1);
    }

    public TokenBagFigure(Drawing drawing, AbstractFigure abstractFigure, PlaceInstanceAccessor placeInstanceAccessor, int n) {
        this.placeInstance = placeInstanceAccessor;
        this.lockDrawing = drawing;
        this.cardFigure = new TextFigure();
        this.cardFigure.setReadOnly(true);
        this.cardFigure.setAttribute("FontStyle", (Object)new Integer(2));
        this.attributes = new FigureAttributes();
        if (abstractFigure != null) {
            this.setParent((ParentFigure)abstractFigure);
        }
        this.setMarkingAppearance(n);
        try {
            this.forwarder = new RemoteEventForwarder((EventListener)this);
            this.placeInstance.addRemoteEventListener((RemoteEventListener)this.forwarder);
        }
        catch (RemoteException remoteException) {
            logger.error((Object)remoteException.getMessage(), (Throwable)remoteException);
        }
    }

    @Override
    protected Vector<Handle> basicHandles() {
        Vector<Handle> vector = super.basicHandles();
        vector.addElement((Handle)new NullHandle((Figure)this, RelativeLocator.northWest()));
        vector.addElement((Handle)new NullHandle((Figure)this, RelativeLocator.northEast()));
        vector.addElement((Handle)new NullHandle((Figure)this, RelativeLocator.southWest()));
        vector.addElement((Handle)new NullHandle((Figure)this, RelativeLocator.southEast()));
        return vector;
    }

    public boolean canBeParent(ParentFigure parentFigure) {
        return parentFigure instanceof AbstractFigure && (this.figure == null || this.figure == parentFigure);
    }

    private void unsetParent() {
        if (this.figure != null) {
            this.figure.removeChild((ChildFigure)this);
            this.figure = null;
        }
    }

    public boolean setParent(ParentFigure parentFigure) {
        if (!this.canBeParent(parentFigure)) {
            return false;
        }
        if (this.figure == parentFigure) {
            return true;
        }
        this.unsetParent();
        this.figure = (AbstractFigure)parentFigure;
        if (parentFigure == null) {
            this.fLocator = null;
        } else {
            parentFigure.addChild((ChildFigure)this);
            if (this.fLocator != null) {
                this.fLocator.setBase(parentFigure.connectedTextLocator((Figure)this));
            } else {
                this.fLocator = new OffsetLocator(parentFigure.connectedTextLocator((Figure)this));
            }
            this.updateLocation();
        }
        return true;
    }

    public ParentFigure parent() {
        return this.figure;
    }

    @Override
    protected void layout() {
        Point point = this.displayBox().getLocation();
        point.translate(3, 3);
        Dimension dimension = new Dimension(0, 0);
        FigureEnumeration figureEnumeration = this.figures();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            Dimension dimension2 = figure.size();
            Point point2 = new Point(point.x + dimension2.width, point.y + dimension2.height);
            figure.basicDisplayBox(point, point2);
            dimension.width = Math.max(dimension.width, dimension2.width);
            dimension.height += dimension2.height + 1;
            point.y += dimension2.height + 1;
        }
        this.fDisplayBox.width = dimension.width + 6;
        this.fDisplayBox.height = dimension.height - 1 + 6;
        this.updateLocation();
        super.layout();
    }

    @Override
    protected boolean needsLayout() {
        Dimension dimension = new Dimension(0, 5);
        FigureEnumeration figureEnumeration = this.figures();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            dimension.width = Math.max(dimension.width, figure.size().width);
            dimension.height += figure.size().height + 1;
        }
        dimension.width += 6;
        return !dimension.equals(this.fDisplayBox.getSize());
    }

    @Override
    public void moveBy(int n, int n2) {
        super.moveBy(n, n2);
        if (this.fLocator != null) {
            this.fLocator.moveBy(n, n2);
        }
    }

    public void updateLocation() {
        if (this.fLocator != null) {
            Point point = this.fLocator.locate((Figure)this.figure);
            Rectangle rectangle = this.displayBox();
            point.x -= rectangle.x + rectangle.width / 2;
            point.y -= rectangle.y + rectangle.height / 2;
            if (point.x != 0 || point.y != 0) {
                this.willChange();
                this.basicMoveBy(point.x, point.y);
                this.changed();
            }
        }
    }

    public void update() {
        if (this.updateTask == null) {
            this.updateTask = new AWTSynchronizedUpdate(new Runnable(){

                @Override
                public void run() {
                    TokenBagFigure.this.executeUpdate();
                }
            });
        }
        this.updateTask.scheduleUpdate();
    }

    private void executeUpdate() {
        Drawing drawing = this.lockDrawing;
        if (drawing == null) {
            return;
        }
        if (this.lockDrawing == null) {
            return;
        }
        if (this.markingAppearance == 1) {
            this.updateCardFigure();
        } else {
            this.updateTokenFigures();
        }
        if (this.listener() != null) {
            this.listener().figureRequestUpdate(new FigureChangeEvent((Figure)this));
        }
    }

    protected void updateCardFigure() {
        try {
            TokenCountsAccessor tokenCountsAccessor = this.placeInstance.getTokenCounts();
            int n = tokenCountsAccessor.getTestedTokenCount();
            int n2 = tokenCountsAccessor.getFreeTokenCount() + n;
            if (n2 != this.cacheMult || n != this.cacheTestMult) {
                this.cacheMult = n2;
                this.cacheTestMult = n;
                if (n > 0) {
                    if (n2 > 0) {
                        this.cardFigure.setText(n2 + "(" + n + ")");
                    } else {
                        this.cardFigure.setText("(" + n + ")");
                    }
                } else if (n2 > 0) {
                    this.cardFigure.setText(String.valueOf(n2));
                } else {
                    this.cardFigure.setText(" ");
                }
            }
        }
        catch (RemoteException remoteException) {
            logger.error((Object)remoteException.getMessage(), (Throwable)remoteException);
        }
    }

    private void updateTokenFigures() {
        this.removeAll();
        this.willChange();
        try {
            MarkingAccessor markingAccessor = this.placeInstance.getMarking();
            boolean bl = this.markingAppearance == 3;
            int n = markingAccessor.getDistinctTokenCount();
            for (int i = 0; i < n; ++i) {
                ObjectAccessor objectAccessor = markingAccessor.getToken(i);
                boolean bl2 = markingAccessor.getTokenTested(i);
                double[] dArray = markingAccessor.getTokenTimes(i);
                int[] nArray = markingAccessor.getTokenTimeMultiplicities(i);
                for (int j = 0; j < dArray.length; ++j) {
                    double d = dArray[j];
                    int n2 = nArray[j];
                    boolean bl3 = bl2 && d == markingAccessor.getCurrentTime();
                    MultipleTokenFigure multipleTokenFigure = new MultipleTokenFigure(n2, bl3, d, objectAccessor, bl);
                    Enumeration enumeration = this.attributes.definedAttributes();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        multipleTokenFigure.setAttribute(string, this.attributes.get(string));
                    }
                    this.add((Figure)multipleTokenFigure);
                }
            }
        }
        catch (RemoteException remoteException) {
            logger.error((Object)remoteException.getMessage(), (Throwable)remoteException);
        }
        this.layout();
        this.changed();
    }

    public void release() {
        Drawing drawing = this.lockDrawing;
        if (drawing == null) {
            return;
        }
        if (this.lockDrawing == null) {
            // empty if block
        }
        if (this.placeInstance != null) {
            try {
                this.placeInstance.removeRemoteEventListener((RemoteEventListener)this.forwarder);
            }
            catch (RemoteException remoteException) {
                logger.error((Object)remoteException.getMessage(), (Throwable)remoteException);
            }
            this.placeInstance = null;
        }
        this.unsetParent();
        this.lockDrawing = null;
        this.removeAll();
        super.release();
    }

    public String toString() {
        if (this.placeInstance == null) {
            return "Detached TokenBagFigure@" + System.identityHashCode((Object)this);
        }
        StringBuffer stringBuffer = new StringBuffer().append('{');
        try {
            MarkingAccessor markingAccessor = this.placeInstance.getMarking();
            int n = markingAccessor.getDistinctTokenCount();
            for (int i = 0; i < n; ++i) {
                ObjectAccessor objectAccessor = markingAccessor.getToken(i);
                int n2 = markingAccessor.getTokenFreeCount(i);
                boolean bl = markingAccessor.getTokenTested(i);
                stringBuffer.append(MultipleTokenFigure.getMultString(n2, bl));
                stringBuffer.append(objectAccessor == null ? "null" : objectAccessor.asString());
                if (i >= n - 1) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append('}');
            return stringBuffer.toString();
        }
        catch (RemoteException remoteException) {
            logger.error((Object)remoteException.getMessage(), (Throwable)remoteException);
            return "";
        }
    }

    public boolean wantSynchronousNotification() {
        return false;
    }

    public void setMarkingAppearance(int n) {
        if (this.markingAppearance != n && n != 0) {
            this.willChange();
            this.markingAppearance = n;
            if (n == 1) {
                this.removeAll();
                this.add((Figure)this.cardFigure);
            }
            this.update();
            this.layout();
            this.changed();
        }
    }

    @Override
    public boolean inspect(DrawingView drawingView, boolean bl) {
        boolean bl2 = super.inspect(drawingView, bl);
        if (bl && !bl2) {
            drawingView.clearSelection();
            int n = this.markingAppearance == 1 ? (this.figure == null ? 3 : 2) : 1;
            this.setAttribute("MarkingAppearance", new Integer(n));
            drawingView.addToSelection((Figure)this);
        }
        return bl2;
    }

    protected PlaceInstanceAccessor getPlaceInstance() {
        return this.placeInstance;
    }

    @Override
    public void update(FigureChangeEvent figureChangeEvent) {
        this.updateLocation();
        super.update(figureChangeEvent);
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (string.equals("MarkingAppearance")) {
            if (this.figure != null) {
                this.figure.setAttribute(string, object);
            } else {
                this.setMarkingAppearance((Integer)object);
            }
        } else {
            if (this.markingAppearance != 1) {
                this.attributes.set(string, object);
            }
            super.setAttribute(string, object);
        }
    }

    public FigureEnumeration getFiguresWithDependencies() {
        FigureEnumeration figureEnumeration = super.getFiguresWithDependencies();
        Vector<AbstractFigure> vector = new Vector<AbstractFigure>(1);
        vector.addElement(this.figure);
        return new MergedFigureEnumerator(figureEnumeration, (FigureEnumeration)new FigureEnumerator(vector));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        throw new NotSerializableException("TokenBagFigure is not serializable!");
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.figure != null) {
            this.figure.addChild((ChildFigure)this);
        }
    }

    protected TextFigure getCardFigure() {
        return this.cardFigure;
    }

    protected int getCachedMultiplicity() {
        return this.cacheMult;
    }

    protected int getCachedTestMultiplicty() {
        return this.cacheTestMult;
    }

    protected void setCachedMultiplicity(int n) {
        this.cacheMult = n;
    }

    protected void setCachedTestMultiplicty(int n) {
        this.cacheTestMult = n;
    }
}

