/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.FigureException;
import CH.ifa.draw.util.Command;
import de.renew.gui.CPNApplication;
import de.renew.gui.GuiPlugin;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.log4j.Logger;

public class LayoutCheckCommand
extends Command {
    public static Logger logger = Logger.getLogger(LayoutCheckCommand.class);
    private static final double OVERLAPWARNINGTHRESHOLD = 0.5;

    public LayoutCheckCommand(String string) {
        super(string);
    }

    public boolean isExecutable() {
        return super.isExecutable();
    }

    public synchronized void execute() {
        try {
            CPNApplication cPNApplication = (CPNApplication)DrawPlugin.getGui();
            Enumeration enumeration = cPNApplication.drawings();
            while (enumeration.hasMoreElements()) {
                Drawing drawing = (Drawing)enumeration.nextElement();
                this.checkSingleDrawing(drawing);
            }
        }
        catch (ClassCastException classCastException) {
            logger.error((Object)classCastException.getMessage(), (Throwable)classCastException);
        }
    }

    private double overlap(Rectangle rectangle, Rectangle rectangle2) {
        Rectangle rectangle3 = rectangle.intersection(rectangle2);
        if (rectangle3.isEmpty()) {
            return 0.0;
        }
        double d = rectangle3.height * rectangle3.width;
        double d2 = rectangle.height * rectangle.width;
        double d3 = rectangle2.height * rectangle2.width;
        return Math.max(d / d2, d / d3);
    }

    private void checkSingleDrawing(Drawing drawing) {
        Vector<Figure> vector = new Vector<Figure>();
        FigureEnumeration figureEnumeration = drawing.figures();
        boolean bl = false;
        while (figureEnumeration.hasMoreElements() && !bl) {
            Figure figure = figureEnumeration.nextFigure();
            if (!(figure instanceof TextFigure)) continue;
            Rectangle rectangle = figure.displayBox();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements() && !bl) {
                TextFigure textFigure = (TextFigure)enumeration.nextElement();
                Rectangle rectangle2 = textFigure.displayBox();
                bl = this.overlap(rectangle, rectangle2) > 0.5;
                if (!bl) continue;
                GuiPlugin.getCurrent().processFigureException(new FigureException("Warning", "Overlapping figures detected", drawing, figure), true);
            }
            if (bl) continue;
            vector.addElement(figure);
        }
        if (!bl) {
            DrawPlugin.getGui().showStatus("Layout check successful");
        }
    }
}

