/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.NullDrawingEditor;
import CH.ifa.draw.util.Command;
import de.renew.gui.CPNDrawing;
import de.renew.gui.FigureWithHighlight;
import java.util.Vector;

public class HighlightSelectCommand
extends Command {
    public HighlightSelectCommand(String string) {
        super(string);
    }

    protected DrawingEditor getEditor() {
        DrawPlugin drawPlugin = DrawPlugin.getCurrent();
        return drawPlugin == null ? NullDrawingEditor.INSTANCE : drawPlugin.getDrawingEditor();
    }

    public boolean isExecutable() {
        if (!super.isExecutable()) {
            return false;
        }
        if (!super.isExecutable()) {
            return false;
        }
        Drawing drawing = this.getEditor().drawing();
        DrawingView drawingView = this.getEditor().view();
        if (drawing instanceof CPNDrawing) {
            if (drawingView.selectionCount() == 1) {
                return drawingView.selectionElements().nextFigure() instanceof FigureWithHighlight;
            }
            if (drawingView.selectionCount() > 1) {
                return true;
            }
        }
        return false;
    }

    public void execute() {
        if (this.isExecutable()) {
            DrawingView drawingView = this.getEditor().view();
            FigureEnumeration figureEnumeration = drawingView.selectionElements();
            Vector<Figure> vector = new Vector<Figure>();
            while (figureEnumeration.hasMoreElements()) {
                Figure figure;
                Figure figure2 = figureEnumeration.nextFigure();
                if (!(figure2 instanceof FigureWithHighlight) || (figure = ((FigureWithHighlight)figure2).getHighlightFigure()) == null) continue;
                vector.addElement(figure);
            }
            if (vector.isEmpty()) {
                this.getEditor().showStatus("Select some nodes (places or transitions) with highlight figures.");
            } else {
                drawingView.clearSelection();
                drawingView.addToSelectionAll(vector);
                drawingView.repairDamage();
                this.getEditor().showStatus("Highlight(s) selected!");
            }
        }
    }
}

