/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import de.renew.gui.ConfigureNetpathController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;

class ConfigureNetpathTab
extends JPanel {
    private JButton editButton;
    private JButton downButton;
    private JButton removeButton;
    private JButton upButton;
    private JList pathList;
    private JPanel buttonPanel;
    private JButton addButton;
    private JScrollPane pathScrollPane;
    private ConfigureNetpathController controller;

    public ConfigureNetpathTab(ConfigureNetpathController configureNetpathController) {
        this.controller = configureNetpathController;
        this.initComponents();
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.addButton = new JButton();
        this.editButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.removeButton = new JButton();
        this.pathScrollPane = new JScrollPane();
        this.pathList = new JList();
        this.setName("Net path");
        this.setLayout(new BorderLayout());
        this.buttonPanel.setLayout(new GridLayout(0, 1));
        this.addButton.setText("Add...");
        this.addButton.setToolTipText("Opens a dialog to add a new entry in front of  the selected entry.");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigureNetpathTab.this.controller.addEntry();
            }
        });
        this.buttonPanel.add(this.addButton);
        this.editButton.setText("Edit...");
        this.editButton.setToolTipText("Opens a dialog for modification of the selected entry.");
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigureNetpathTab.this.controller.editEntry();
            }
        });
        this.buttonPanel.add(this.editButton);
        this.upButton.setText("Move up");
        this.upButton.setToolTipText("Moves the selected entry towards the beginning of the path list");
        this.upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigureNetpathTab.this.controller.upEntry();
            }
        });
        this.buttonPanel.add(this.upButton);
        this.downButton.setText("Move down");
        this.downButton.setToolTipText("Moves the selected entry towards the end of the path list.");
        this.downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigureNetpathTab.this.controller.downEntry();
            }
        });
        this.buttonPanel.add(this.downButton);
        this.removeButton.setText("Delete");
        this.removeButton.setToolTipText("Deletes the selected entry from the path.");
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigureNetpathTab.this.controller.removeEntry();
            }
        });
        this.buttonPanel.add(this.removeButton);
        this.add((Component)this.buttonPanel, "East");
        this.pathList.setToolTipText("Select path entries to move, modify or delete them.");
        this.pathScrollPane.setViewportView(this.pathList);
        this.add((Component)this.pathScrollPane, "Center");
    }

    public void setPathList(ListModel listModel) {
        this.pathList.setModel(listModel);
    }

    public ListModel getPathList() {
        return this.pathList.getModel();
    }

    public ListSelectionModel getSelection() {
        return this.pathList.getSelectionModel();
    }
}

