/*
 * Decompiled with CFR 0.152.
 */
package de.renew.unify;

import de.renew.unify.Calculator;
import de.renew.unify.Impossible;
import de.renew.unify.StateRecorder;
import de.renew.unify.StateRestorer;
import de.renew.unify.Unify;
import de.renew.unify.Variable;
import java.util.HashSet;
import java.util.Set;

public final class CalculationChecker {
    private Set<Variable> lateVariables = new HashSet<Variable>();
    private Set<Variable> earlyVariables = new HashSet<Variable>();

    public void reset() {
        this.lateVariables.clear();
        this.earlyVariables.clear();
    }

    public void addEarlyVariable(final Variable variable, StateRecorder stateRecorder) throws Impossible {
        if (!this.earlyVariables.contains(variable)) {
            if (stateRecorder != null) {
                stateRecorder.record(new StateRestorer(){

                    @Override
                    public void restore() {
                        CalculationChecker.this.earlyVariables.remove(variable);
                    }
                });
            }
            this.earlyVariables.add(variable);
        }
    }

    public void addCalculated(Class<?> clazz, Object object, Object object2, StateRecorder stateRecorder) throws Impossible {
        Unify.unify(object, new Calculator(clazz, object2, stateRecorder), stateRecorder);
    }

    public void addLateVariable(final Variable variable, StateRecorder stateRecorder) throws Impossible {
        if (!this.lateVariables.contains(variable)) {
            if (stateRecorder != null) {
                stateRecorder.record(new StateRestorer(){

                    @Override
                    public void restore() {
                        CalculationChecker.this.lateVariables.remove(variable);
                    }
                });
            }
            this.lateVariables.add(variable);
        }
    }

    private boolean checkLateVariables() {
        for (Variable variable : this.lateVariables) {
            if (variable.isComplete()) continue;
            return false;
        }
        return true;
    }

    private boolean checkEarlyVariables() {
        for (Variable variable : this.earlyVariables) {
            if (variable.isBound()) continue;
            return false;
        }
        return true;
    }

    public boolean isConsistent() {
        return this.checkLateVariables() && this.checkEarlyVariables();
    }
}

