/*
 * Decompiled with CFR 0.152.
 */
package de.renew.unify;

import de.renew.unify.BacklinkSet;
import de.renew.unify.IdentityWrapper;
import de.renew.unify.Impossible;
import de.renew.unify.Notifiable;
import de.renew.unify.RecorderChecker;
import de.renew.unify.Referable;
import de.renew.unify.Reference;
import de.renew.unify.Referer;
import de.renew.unify.StateRecorder;
import de.renew.unify.StateRestorer;
import de.renew.unify.Unifiable;
import de.renew.unify.Unify;
import de.renew.unify.Unknown;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.Set;

public abstract class Aggregate
implements Unifiable,
Referable,
Referer,
Serializable {
    private BacklinkSet backlinkSet;
    final transient RecorderChecker recorderChecker;
    final Reference[] references;
    private boolean complete;
    private boolean bound;

    Aggregate(int n) {
        this.recorderChecker = new RecorderChecker(null);
        this.references = Unify.makeUnknownReferenceArray(n, this);
        this.complete = n == 0;
        boolean bl = this.bound = n == 0;
        if (!this.complete) {
            this.backlinkSet = new BacklinkSet();
        }
    }

    Aggregate(Object[] objectArray, StateRecorder stateRecorder) {
        this.recorderChecker = new RecorderChecker(stateRecorder);
        this.references = Unify.cleanupReferenceArray(objectArray, this, stateRecorder);
        this.complete = this.calculateComplete();
        this.bound = this.calculateBound();
        if (!this.complete) {
            this.backlinkSet = new BacklinkSet();
        }
    }

    public Object[] asArray(Class<?> clazz) {
        return this.copyInto((Object[])Array.newInstance(clazz, this.references.length));
    }

    public Object[] asArray() {
        return this.copyInto(new Object[this.references.length]);
    }

    public Object[] copyInto(Object[] objectArray) {
        for (int i = 0; i < this.references.length; ++i) {
            objectArray[i] = this.references[i].value;
        }
        return objectArray;
    }

    private boolean calculateComplete() {
        for (int i = 0; i < this.references.length; ++i) {
            if (this.references[i].complete) continue;
            return false;
        }
        return true;
    }

    private boolean calculateBound() {
        for (int i = 0; i < this.references.length; ++i) {
            if (this.references[i].bound) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public boolean isBound() {
        return this.bound;
    }

    @Override
    public void possiblyCompleted(Set<Notifiable> set, StateRecorder stateRecorder) throws Impossible {
        if (this.references.length == 0) {
            throw new RuntimeException("An empty aggregate became completed.");
        }
        if (!this.complete && this.calculateComplete()) {
            if (stateRecorder != null) {
                stateRecorder.record(new StateRestorer(){

                    @Override
                    public void restore() {
                        Aggregate.this.complete = false;
                    }
                });
            }
            this.complete = true;
            if (this.calculateBound()) {
                if (stateRecorder != null) {
                    stateRecorder.record(new StateRestorer(){

                        @Override
                        public void restore() {
                            Aggregate.this.bound = false;
                        }
                    });
                }
                this.bound = true;
            }
            this.checkBacklinkSet();
            this.backlinkSet.updateBacklinked(this, this, set, stateRecorder);
            final BacklinkSet backlinkSet = this.backlinkSet;
            if (stateRecorder != null) {
                stateRecorder.record(new StateRestorer(){

                    @Override
                    public void restore() {
                        Aggregate.this.backlinkSet = backlinkSet;
                    }
                });
            }
            this.backlinkSet = null;
        }
    }

    private void checkBacklinkSet() {
        if (this.backlinkSet == null) {
            if (!this.complete) {
                throw new RuntimeException("A complete object received a backlink. Strange");
            }
            throw new RuntimeException("An incomplete object lacks a backlink set. Strange");
        }
    }

    @Override
    public void addBacklink(Reference reference, StateRecorder stateRecorder) {
        this.recorderChecker.checkRecorder(stateRecorder);
        this.checkBacklinkSet();
        this.backlinkSet.addBacklink(reference, stateRecorder);
    }

    void unifySilently(Aggregate aggregate, StateRecorder stateRecorder, Set<Notifiable> set) throws Impossible {
        if (aggregate.references.length != this.references.length) {
            throw new Impossible();
        }
        for (int i = 0; i < this.references.length; ++i) {
            Unify.unifySilently(this.references[i].value, aggregate.references[i].value, stateRecorder, set);
        }
    }

    @Override
    public void occursCheck(Unknown unknown, Set<IdentityWrapper> set) throws Impossible {
        if (this.complete) {
            return;
        }
        IdentityWrapper identityWrapper = new IdentityWrapper(this);
        if (set.contains(identityWrapper)) {
            return;
        }
        set.add(identityWrapper);
        for (int i = 0; i < this.references.length; ++i) {
            this.references[i].occursCheck(unknown, set);
        }
    }

    boolean matches(Aggregate aggregate) {
        if (this.references.length != aggregate.references.length) {
            return false;
        }
        for (int i = 0; i < this.references.length; ++i) {
            if (!(this.references[i].value == null ? aggregate.references[i].value != null : !this.references[i].value.equals(aggregate.references[i].value))) continue;
            return false;
        }
        return true;
    }

    protected int refHash(int n) {
        if (this.references[n].value == null) {
            return 1;
        }
        return this.references[n].value.hashCode();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (!this.isComplete()) {
            throw new NotSerializableException("de.renew.unify.Aggregate: " + String.valueOf(this) + " is not complete.");
        }
        objectOutputStream.defaultWriteObject();
    }

    public abstract Iterator<Object> iterator();
}

