/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.simulator;

import de.renew.engine.searcher.Finder;
import de.renew.engine.searcher.Searchable;
import de.renew.engine.searcher.Searcher;
import de.renew.engine.searchqueue.SearchQueue;
import de.renew.engine.simulator.SimulationThreadPool;
import java.util.Enumeration;
import java.util.Hashtable;

class DelayingInsertionFinder
implements Finder {
    private Finder finder;
    private Searchable searchable;
    private Hashtable<Searchable, Double> times = new Hashtable();

    DelayingInsertionFinder(Finder finder) {
        this.finder = finder;
    }

    void setSearchable(Searchable searchable) {
        this.searchable = searchable;
    }

    private double getTimeFor(Searchable searchable) {
        return this.times.get(searchable);
    }

    @Override
    public void found(Searcher searcher) {
        double d;
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        double d2 = searcher.getEarliestTime();
        if (d2 < (d = this.times.containsKey(this.searchable) ? this.getTimeFor(this.searchable) : Double.POSITIVE_INFINITY)) {
            this.times.put(this.searchable, new Double(d2));
        }
        if (d2 <= SearchQueue.getTime()) {
            this.finder.found(searcher);
        }
    }

    @Override
    public boolean isCompleted() {
        return this.finder.isCompleted();
    }

    public void flushIntoSearchQueue() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        Enumeration<Searchable> enumeration = this.times.keys();
        while (enumeration.hasMoreElements()) {
            Searchable searchable = enumeration.nextElement();
            double d = this.getTimeFor(searchable);
            SearchQueue.include(searchable, d);
        }
    }
}

