/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin.load;

import de.renew.plugin.CollectionLister;
import de.renew.plugin.DependencyCheckList;
import de.renew.plugin.DependencyNotFulfilledException;
import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginClassLoader;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.load.AbstractPluginLoader;
import de.renew.plugin.load.IExtendedProgressBar;
import de.renew.plugin.load.PluginLoader;
import de.renew.plugin.locate.PluginLocationFinders;
import java.beans.PropertyChangeEvent;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class PluginLoaderComposition
implements PluginLoader {
    public static Logger logger = Logger.getLogger(PluginLoaderComposition.class);
    private Collection<PluginLoader> _loaders = new Vector<PluginLoader>();
    private static IExtendedProgressBar progressBar = null;

    public static void setProgressBar(IExtendedProgressBar iExtendedProgressBar) {
        progressBar = iExtendedProgressBar;
    }

    /*
     * WARNING - void declaration
     */
    public Collection<IPlugin> loadPlugins() {
        Collection<Object> dependencyNotFulfilledException;
        int n;
        logger.info((Object)"loading plugins...");
        DependencyCheckList<PluginProperties> dependencyCheckList = new DependencyCheckList<PluginProperties>();
        Collection<PluginProperties> collection2 = PluginLocationFinders.getInstance().findPluginLocations();
        Vector<IPlugin> vector = new Vector<IPlugin>();
        PluginProperties object = null;
        Vector<String> vector2 = new Vector<String>();
        for (PluginProperties object2 : collection2) {
            if (object2.getName().equals("Renew Splashscreen")) {
                object = object2;
                continue;
            }
            dependencyCheckList.addElement(DependencyCheckList.DependencyElement.create(object2));
        }
        List list = dependencyCheckList.getFulfilledObjects();
        for (PluginProperties pluginProperties : list) {
            logger.debug((Object)pluginProperties);
        }
        boolean bl = false;
        int n2 = object != null ? -1 : 0;
        PluginClassLoader pluginClassLoader = PluginManager.getInstance().getPluginClassLoader();
        URL[] uRLArray = new URL[]{};
        for (n = 0; n < list.size(); ++n) {
            PluginProperties pluginProperties = (PluginProperties)list.get(n);
            uRLArray = AbstractPluginLoader.unifyURL(pluginProperties.getURL());
            for (int n4 = 0; n4 < uRLArray.length; ++n4) {
                pluginClassLoader.addURL(uRLArray[n4]);
            }
        }
        for (n = n2; n < list.size(); ++n) {
            if (progressBar != null) {
                void var7_10;
                void vector3 = var7_10++;
                double hashMap = n + 1;
                double d = list.size();
                int n3 = (int)(hashMap / d * 100.0);
                try {
                    progressBar.propertyChange(new PropertyChangeEvent(this, "progress", (int)vector3, n3));
                }
                catch (Exception exception) {
                    progressBar = null;
                }
            }
            PluginProperties pluginProperties = n == -1 ? object : (PluginProperties)list.get(n);
            if (PluginManager.getInstance().getPluginByName(pluginProperties.getName()) != null) {
                logger.debug((Object)("PluginLoader: A plugin with the name " + pluginProperties.getName() + " has already been loaded. Skipping " + String.valueOf(pluginProperties.getURL())));
                continue;
            }
            IPlugin iPlugin = this.loadPlugin(pluginProperties);
            if (iPlugin != null) {
                try {
                    PluginManager.getInstance().addPlugin(iPlugin);
                    if (progressBar != null) {
                        try {
                            progressBar.propertyChange(new PropertyChangeEvent(this, "pluginLoaded", null, iPlugin.getName()));
                        }
                        catch (Exception exception) {
                            progressBar = null;
                        }
                    }
                    if (!vector2.contains(dependencyNotFulfilledException = iPlugin.getProperties().getProvisions())) {
                        vector2.addAll(dependencyNotFulfilledException);
                    }
                    vector.add(iPlugin);
                    continue;
                }
                catch (DependencyNotFulfilledException dependencyNotFulfilledException2) {
                    assert (false) : "The PluginManager doubts our dependency check for " + String.valueOf(iPlugin);
                    continue;
                }
            }
            logger.debug((Object)("PluginLoaderComposition: did not load plugin from " + String.valueOf(pluginProperties)));
            dependencyNotFulfilledException = dependencyCheckList.removeElementWithDependencies(pluginProperties);
            if (!dependencyNotFulfilledException.isEmpty()) {
                logger.debug((Object)"PluginLoaderComposition: recalculated dependencies.");
            }
            list = dependencyCheckList.getFulfilledObjects();
            --n;
        }
        Collection collection = dependencyCheckList.getUnfulfilled();
        if (!collection.isEmpty()) {
            logger.warn((Object)"\nThere are plugins with unfulfilled dependencies:");
            Vector<String> vector3 = new Vector<String>();
            HashMap hashMap = new HashMap();
            for (DependencyCheckList.DependencyElement dependencyElement : collection) {
                logger.warn((Object)("Plugin with unfullfilled dependencies: " + dependencyElement.toStringExtended(vector2) + "\n"));
                for (String string : dependencyElement.getProvisions()) {
                    if (vector3.contains(string)) continue;
                    vector3.add(string);
                }
                for (String string : dependencyElement.getMissingRequirements(vector2)) {
                    String string2;
                    if (vector3.contains(string)) continue;
                    List<String> list2 = new Vector();
                    if (hashMap.containsKey(string)) {
                        list2 = (List)hashMap.get(string);
                    }
                    if (!list2.contains(string2 = dependencyElement.getPluginName())) {
                        list2.add(string2);
                    }
                    hashMap.put(string, list2);
                }
                for (String string : dependencyElement.getProvisions()) {
                    if (!hashMap.containsKey(string)) continue;
                    hashMap.remove(string);
                }
            }
            dependencyNotFulfilledException = new Vector();
            for (Iterator<String> iterator : hashMap.keySet()) {
                dependencyNotFulfilledException.add((CallSite)((Object)(iterator + " [Required by: " + CollectionLister.toString((Collection)hashMap.get(iterator), ", ") + "]")));
            }
            logger.error((Object)("\nPLEASE add the plugin(s) with the following provisions in their plugin.cfg\n\n* " + CollectionLister.toString(dependencyNotFulfilledException, "\n* ") + "\n"));
        }
        if (progressBar != null) {
            progressBar.close();
        }
        return vector;
    }

    public void addLoader(PluginLoader pluginLoader) {
        this._loaders.add(pluginLoader);
    }

    public void removeLoader(PluginLoader pluginLoader) {
        this._loaders.remove(pluginLoader);
    }

    @Override
    public IPlugin loadPlugin(PluginProperties pluginProperties) {
        for (PluginLoader pluginLoader : this._loaders) {
            try {
                IPlugin iPlugin = pluginLoader.loadPlugin(pluginProperties);
                if (iPlugin == null) continue;
                return iPlugin;
            }
            catch (Exception exception) {
                logger.error((Object)("PluginLoaderComposition: " + String.valueOf(exception) + " occured when " + String.valueOf(pluginLoader) + " tried to load plugin from " + String.valueOf(pluginProperties.getURL())));
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
        logger.error((Object)("No loader was able to load " + pluginProperties.getName() + "!"));
        return null;
    }

    @Override
    public IPlugin loadPluginFromURL(URL uRL) {
        IPlugin iPlugin = null;
        PluginManager pluginManager = PluginManager.getInstance();
        PluginProperties pluginProperties = PluginLocationFinders.getInstance().checkPluginLocation(uRL);
        if (pluginProperties != null) {
            if (pluginManager.checkDependenciesFulfilled(pluginProperties)) {
                iPlugin = this.loadPlugin(pluginProperties);
            } else {
                logger.error((Object)("Dependencies are not fulfilled for plugin \n\t" + pluginProperties.getName() + "\nlocated at \n\t" + String.valueOf(pluginProperties.getURL())));
            }
        } else {
            for (PluginLoader pluginLoader : this._loaders) {
                try {
                    iPlugin = pluginLoader.loadPluginFromURL(uRL);
                    if (iPlugin == null) continue;
                    break;
                }
                catch (Exception exception) {
                    logger.error((Object)("PluginLoaderComposition: " + String.valueOf(exception) + " occured when " + String.valueOf(pluginLoader) + " tried to load plugin from " + String.valueOf(uRL)));
                    logger.debug((Object)exception.getMessage(), (Throwable)exception);
                }
            }
        }
        if (iPlugin != null) {
            try {
                pluginManager.addPlugin(iPlugin);
            }
            catch (DependencyNotFulfilledException dependencyNotFulfilledException) {
                logger.error((Object)("Dependencies are not fulfilled for " + String.valueOf(iPlugin) + " loaded from " + String.valueOf(uRL)));
                return null;
            }
        }
        return iPlugin;
    }
}

