/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin.command;

import de.renew.plugin.CollectionLister;
import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginManager;
import de.renew.plugin.command.CLCommand;
import de.renew.plugin.command.CLCommandHelper;
import java.io.PrintStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class UnloadCommand
implements CLCommand {
    public static Logger logger = Logger.getLogger(UnloadCommand.class);

    @Override
    public void execute(String[] stringArray, PrintStream printStream) {
        if (stringArray.length == 1 && CLCommandHelper.isFlagSet(stringArray, "-h", "--h", "-help", "--help")) {
            printStream.println("usage: unload [-v | -r | -m] <PluginName>\nDescription: \nuse parameter -v to see a list of all dependent plug-ins\nuse parameter -r to unload all dependent plug-ins recursivly\nuse parameter -m to remove given plug-ins iff there are no dependors and\n\t\t at least one further plug-in which provides the same service (EXPERIMENTAL!!!)");
            return;
        }
        boolean bl = CLCommandHelper.isFlagSet(stringArray, "-v");
        boolean bl2 = CLCommandHelper.isFlagSet(stringArray, "-r");
        boolean bl3 = CLCommandHelper.isFlagSet(stringArray, "-m");
        String string = CLCommandHelper.getPluginName(stringArray);
        if (string == null || string.trim().length() == 0) {
            printStream.println("UnloadCommand: please set name of plug-in!");
            return;
        }
        IPlugin iPlugin = PluginManager.getInstance().getPluginByName(string);
        if (iPlugin == null) {
            printStream.println("UnloadCommand: did not find plug-in with name " + string);
            return;
        }
        printStream.println("\n\n------- UNLOAD -------\n\n");
        try {
            Map<String, Collection<IPlugin>> map = CLCommandHelper.checkDependencies(iPlugin, bl3);
            Set<Map.Entry<String, Collection<IPlugin>>> set = map.entrySet();
            if (set.isEmpty()) {
                PluginManager.getInstance().stop(iPlugin);
                printStream.println("Plug-in " + String.valueOf(iPlugin) + " successfully removed.");
            } else if (bl2) {
                List<IPlugin> list = CLCommandHelper.getDependers(iPlugin, bl3);
                printStream.println("Recursively unloading:\n -> " + CollectionLister.toString(list, "\n -> "));
                PluginManager.getInstance().stop(list);
                printStream.println("\nDependent plug-ins successfully removed:\n -> " + CollectionLister.toString(list, "\n -> "));
                printStream.println("\nFinally: Plug-in " + String.valueOf(iPlugin) + " successfully removed.");
            } else {
                printStream.println("UnloadCommand: could not unload " + String.valueOf(iPlugin) + ": there are plug-ins depending on it.");
                if (bl) {
                    for (Map.Entry<String, Collection<IPlugin>> entry : set) {
                        printStream.print(entry.getKey() + ":\n\t -> ");
                        printStream.println(CollectionLister.toString(entry.getValue(), "\n\t -> "));
                    }
                } else {
                    printStream.println("Use \"unload -v <PluginName>\" to see a list.");
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (NumberFormatException numberFormatException) {
            printStream.println("cleanup canceled.");
        }
        catch (Exception exception) {
            printStream.println("cleanup canceled: " + String.valueOf(exception) + "; " + exception.getMessage());
            logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    @Override
    public String getDescription() {
        return "cleans up (deactivates) a plugin";
    }

    @Override
    public String getArguments() {
        return "pluginNames";
    }
}

