/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin.command;

import de.renew.plugin.CollectionLister;
import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.command.CLCommand;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Vector;
import org.apache.log4j.Logger;

public class InfoCommand
implements CLCommand {
    public static Logger logger = Logger.getLogger(InfoCommand.class);

    @Override
    public void execute(String[] stringArray, PrintStream printStream) {
        IPlugin iPlugin;
        String string = CollectionLister.toString(stringArray, " ");
        if (stringArray.length > 0 && ("-c".equals(stringArray[0]) || "c".equals(stringArray[0]) || "--comments".equals(stringArray[0]) || "comments".equals(stringArray[0]))) {
            printStream.println("Please use list command instead!");
        }
        if ((iPlugin = PluginManager.getInstance().getPluginByName(string)) == null) {
            logger.debug((Object)("InfoCommand: did not find Plugin with name " + string));
            return;
        }
        try {
            PluginProperties pluginProperties = iPlugin.getProperties();
            printStream.println(InfoCommand.renderProperties(pluginProperties));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (NumberFormatException numberFormatException) {
            printStream.println("cleanup canceled.");
        }
        catch (Exception exception) {
            printStream.println("cleanup canceled: " + String.valueOf(exception) + "; " + exception.getMessage());
            logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    public static String renderProperties(PluginProperties pluginProperties) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Properties of plugin ");
        stringBuffer.append(pluginProperties.getName());
        stringBuffer.append("\n\tloaded from ");
        stringBuffer.append(pluginProperties.getURL());
        stringBuffer.append("\n\t");
        String string = pluginProperties.getMainClass();
        if ("".equals(string)) {
            stringBuffer.append("no main class");
        } else {
            stringBuffer.append("main class is ");
            stringBuffer.append(string);
        }
        stringBuffer.append("\n\tprovides ");
        stringBuffer.append(CollectionLister.toString(pluginProperties.getProvisions()));
        stringBuffer.append("\n\trequires ");
        stringBuffer.append(CollectionLister.toString(pluginProperties.getRequirements()));
        stringBuffer.append("\n\tversion information \n\t\t");
        stringBuffer.append(pluginProperties.getVersion());
        stringBuffer.append("\n\t\t");
        stringBuffer.append(pluginProperties.getVersionDate());
        stringBuffer.append("\n\t\t");
        stringBuffer.append(pluginProperties.getVersionText());
        stringBuffer.append("\n");
        Vector<Object> vector = new Vector<String>();
        vector.addAll(pluginProperties.getKeys());
        StringBuffer stringBuffer2 = new StringBuffer();
        Collections.sort(vector);
        for (String charSequence2 : vector) {
            if (!pluginProperties.isKnownProperty(charSequence2)) continue;
            stringBuffer2.append("\t");
            stringBuffer2.append(charSequence2);
            stringBuffer2.append("=");
            stringBuffer2.append(pluginProperties.getProperty(charSequence2));
            stringBuffer2.append("\n");
        }
        if (stringBuffer2.length() > 0) {
            stringBuffer.append("Other properties:\n");
            stringBuffer.append(stringBuffer2);
        }
        vector = new Vector<String>(pluginProperties.getUnsetProperties());
        StringBuffer stringBuffer3 = new StringBuffer();
        Collections.sort(vector);
        for (String string2 : vector) {
            if (!pluginProperties.isKnownProperty(string2)) continue;
            stringBuffer3.append("\t");
            stringBuffer3.append(string2);
            stringBuffer3.append("=");
            stringBuffer3.append(pluginProperties.getProperty(string2));
            stringBuffer3.append("\n");
        }
        if (stringBuffer3.length() > 0) {
            stringBuffer.append("Unset properties:\n");
            stringBuffer.append(stringBuffer3);
        }
        return stringBuffer.toString();
    }

    @Override
    public String getDescription() {
        return "view properties of a loaded plugin.";
    }

    @Override
    public String getArguments() {
        return "pluginNames";
    }
}

