/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.function;

import de.renew.expression.Function;
import de.renew.formalism.function.Executor;
import de.renew.unify.Impossible;
import de.renew.unify.Tuple;
import de.renew.util.ReflectionSerializer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;

public class ConstructorFunction
implements Function {
    public static Logger logger = Logger.getLogger(ConstructorFunction.class);
    transient Constructor<?> constr;

    public ConstructorFunction(Constructor<?> constructor) {
        this.constr = constructor;
    }

    public Object function(Object object) throws Impossible {
        Tuple tuple = (Tuple)object;
        Object[] objectArray = new Object[tuple.getArity()];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = tuple.getComponent(i);
        }
        try {
            return Executor.executeConstructor(this.constr, objectArray);
        }
        catch (Exception exception) {
            if (exception instanceof InvocationTargetException) {
                Throwable throwable = ((InvocationTargetException)exception).getTargetException();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Constructor call resulted in an exception:" + String.valueOf(throwable) + " while executing " + this.toString()), throwable);
                }
                throw new Impossible("Constructor call resulted in an exception: " + String.valueOf(throwable), throwable);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Exception occured during constructor call: " + String.valueOf(exception) + " while executing " + this.toString()), (Throwable)exception);
            }
            throw new Impossible("Exception occured during constructor call: " + String.valueOf(exception), (Throwable)exception);
        }
        catch (LinkageError linkageError) {
            logger.warn((Object)("LinkageError occured during constructor call: " + String.valueOf(linkageError) + " while executing " + this.toString()), (Throwable)linkageError);
            throw new Impossible("LinkageError occured during constructor call: " + String.valueOf(linkageError), (Throwable)linkageError);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        ReflectionSerializer.writeConstructor((ObjectOutputStream)objectOutputStream, this.constr);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.constr = ReflectionSerializer.readConstructor((ObjectInputStream)objectInputStream);
    }

    public final String toString() {
        return "ConstrFunc: " + this.constr.toString();
    }
}

