/*
 * Decompiled with CFR 0.152.
 */
package de.renew.util;

import de.renew.plugin.PluginProperties;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.log4j.Logger;

public class FileFinder {
    protected static final Logger logger = Logger.getLogger(FileFinder.class);

    public static ArrayList<URI> searchPluginLocations(String string) {
        String string2 = PluginProperties.getUserProperties().getProperty("pluginLocations");
        String[] stringArray = string2.split(File.pathSeparator);
        ArrayList<URI> arrayList = new ArrayList<URI>();
        for (String string3 : stringArray) {
            File file = new File(string3);
            if (!file.exists()) {
                logger.warn((Object)("\n\n\t ===> The specified plugin location [" + string3 + "] does not exist! (maybe specified with .renew.properties or start.sh or ...)\n\n"));
                continue;
            }
            ArrayList<URI> arrayList2 = FileFinder.searchLocation(file, "." + string);
            logger.debug((Object)("Search result for location " + string3 + ": " + String.valueOf(arrayList2)));
            arrayList.addAll(arrayList2);
        }
        return arrayList;
    }

    public static ArrayList<URI> searchLocation(File file, String string) {
        ArrayList<URI> arrayList = new ArrayList<URI>();
        for (File file2 : file.listFiles()) {
            if (file2.isDirectory()) {
                arrayList.addAll(FileFinder.searchLocation(file2, string));
                continue;
            }
            if (file2.getName().endsWith(".jar")) {
                try {
                    JarFile jarFile = new JarFile(file2);
                    Enumeration<JarEntry> enumeration = jarFile.entries();
                    while (enumeration.hasMoreElements()) {
                        JarEntry jarEntry = enumeration.nextElement();
                        if (!jarEntry.getName().endsWith(string)) continue;
                        URI uRI = URI.create("jar:" + String.valueOf(file2.toURI()) + "!/" + String.valueOf(jarEntry));
                        arrayList.add(uRI);
                    }
                    jarFile.close();
                }
                catch (IOException iOException) {
                    logger.error((Object)("Cannot open JAR File: " + String.valueOf(file2)));
                    logger.debug((Object)iOException);
                }
                continue;
            }
            if (!file2.getName().endsWith(string)) continue;
            arrayList.add(file2.toURI());
        }
        return arrayList;
    }

    public static URI searchFile(String string) {
        String string2 = string.substring(string.lastIndexOf(".") + 1);
        ArrayList<URI> arrayList = FileFinder.searchPluginLocations(string2);
        for (URI uRI : arrayList) {
            if (!uRI.toString().endsWith(string)) continue;
            return uRI;
        }
        return null;
    }
}

