/*
 * Decompiled with CFR 0.152.
 */
package de.renew.ant;

import de.renew.ant.AbstractEnhancedJavaCCTask;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Replace;
import org.apache.tools.ant.taskdefs.optional.javacc.JavaCC;

public class EnhancedJavaCCTask
extends AbstractEnhancedJavaCCTask {
    private String jdkversion;

    public void setJDKversion(String string) {
        this.jdkversion = string;
    }

    public EnhancedJavaCCTask() {
        super("javacc");
    }

    @Override
    protected void mkdirAndExecuteJavaCC(File file) throws BuildException {
        super.mkdirAndExecuteJavaCC(file);
        this.suppressWarningsInTokenManager(file, this.getGenerationDirectory(file));
    }

    @Override
    protected void executeJavaCC(File file, File file2) throws BuildException {
        JavaCC javaCC = (JavaCC)this.getProject().createTask(this.singleTaskName);
        javaCC.setJavacchome(this.javacchome);
        javaCC.setTarget(file);
        javaCC.setOutputdirectory(file2);
        if (this.jdkversion != null) {
            javaCC.setJDKversion(this.jdkversion);
        }
        javaCC.init();
        javaCC.execute();
    }

    private void suppressWarningsInTokenManager(File file, File file2) {
        String string = file.getName();
        if (string == null || !string.endsWith(".jj")) {
            this.log("Cannot determine filename of token manager to add @SuppressWarnings. Skipping this step.", 1);
        } else {
            String string2 = string.substring(0, string.length() - 3) + "TokenManager.java";
            File file3 = new File(file2, string2);
            this.log("Trying to insert @SuppressWarnings(\"unused\") in " + String.valueOf(file3), 3);
            Replace replace = (Replace)this.getProject().createTask("replace");
            replace.setFile(file3);
            Replace.NestedString nestedString = replace.createReplaceToken();
            nestedString.addText("/** Token Manager. */\npublic class");
            Replace.NestedString nestedString2 = replace.createReplaceValue();
            nestedString2.addText("/** Token Manager. */\n@SuppressWarnings(\"unused\")\npublic class");
            replace.execute();
        }
    }
}

