/*
 * Decompiled with CFR 0.152.
 */
package de.renew.remote;

import de.renew.application.SimulationEnvironment;
import de.renew.engine.simulator.BindingList;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.net.NetInstance;
import de.renew.net.NetInstanceList;
import de.renew.remote.NetInstanceAccessor;
import de.renew.remote.NetInstanceAccessorImpl;
import de.renew.remote.SimulatorAccessor;
import de.renew.remote.SocketFactoryDeterminer;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class SimulatorAccessorImpl
extends UnicastRemoteObject
implements SimulatorAccessor {
    public static Logger logger = Logger.getLogger(SimulatorAccessorImpl.class);
    private final SimulationEnvironment environment;

    public SimulatorAccessorImpl(SimulationEnvironment simulationEnvironment) throws RemoteException {
        super(0, SocketFactoryDeterminer.getInstance(), SocketFactoryDeterminer.getInstance());
        this.environment = simulationEnvironment;
    }

    @Override
    public NetInstanceAccessor[] getNetInstances() throws RemoteException {
        Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<NetInstanceAccessor[]>(){

            @Override
            public NetInstanceAccessor[] call() throws Exception {
                NetInstance[] netInstanceArray = NetInstanceList.getAll();
                NetInstanceAccessor[] netInstanceAccessorArray = new NetInstanceAccessor[netInstanceArray.length];
                for (int i = 0; i < netInstanceArray.length; ++i) {
                    netInstanceAccessorArray[i] = new NetInstanceAccessorImpl(netInstanceArray[i], SimulatorAccessorImpl.this.environment);
                }
                return netInstanceAccessorArray;
            }
        });
        try {
            return (NetInstanceAccessor[])future.get();
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            logger.error((Object)"Simulation thread threw an exception", (Throwable)executionException);
        }
        return null;
    }

    @Override
    public boolean isActive() throws RemoteException {
        Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return SimulatorAccessorImpl.this.environment.getSimulator().isActive();
            }
        });
        try {
            return (Boolean)future.get();
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            logger.error((Object)"Simulation thread threw an exception", (Throwable)executionException);
        }
        return false;
    }

    @Override
    public void startRun() throws RemoteException {
        Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                SimulatorAccessorImpl.this.environment.getSimulator().startRun();
                return null;
            }
        });
        try {
            future.get();
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            logger.error((Object)"Simulation thread threw an exception", (Throwable)executionException);
        }
    }

    @Override
    public void stopRun() throws RemoteException {
        Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                SimulatorAccessorImpl.this.environment.getSimulator().stopRun();
                return null;
            }
        });
        try {
            future.get();
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            logger.error((Object)"Simulation thread threw an exception", (Throwable)executionException);
        }
    }

    @Override
    public void terminateRun() throws RemoteException {
        Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                SimulatorAccessorImpl.this.environment.getSimulator().terminateRun();
                return null;
            }
        });
        try {
            future.get();
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            logger.error((Object)"Simulation thread threw an exception", (Throwable)executionException);
        }
    }

    @Override
    public int step() throws RemoteException {
        Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return SimulatorAccessorImpl.this.environment.getSimulator().step();
            }
        });
        try {
            return (Integer)future.get();
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            logger.error((Object)"Simulation thread threw an exception", (Throwable)executionException);
        }
        return -1;
    }

    @Override
    public void refresh() throws RemoteException {
        Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                SimulatorAccessorImpl.this.environment.getSimulator().refresh();
                return null;
            }
        });
        try {
            future.get();
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            logger.error((Object)"Simulation thread threw an exception", (Throwable)executionException);
        }
    }

    public void totallyStopSimulation() throws RemoteException {
        Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                SimulatorAccessorImpl.this.environment.getSimulator().stopRun();
                BindingList.waitUntilEmpty();
                return null;
            }
        });
        try {
            future.get();
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            logger.error((Object)"Simulation thread threw an exception", (Throwable)executionException);
        }
    }
}

