/*
 * Decompiled with CFR 0.152.
 */
package de.renew.remote;

import de.renew.application.SimulatorPlugin;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.PropertyHelper;
import de.renew.remote.NetInstanceAccessor;
import de.renew.remote.RemotePlugin;
import de.renew.remote.RemoteServerRegistryListener;
import de.renew.remote.Server;
import de.renew.remote.ServerImpl;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class RemoteServerRegistry {
    public static Logger logger = Logger.getLogger(RemoteServerRegistry.class);
    private static RemoteServerRegistry _instance = null;
    private Vector<ServerDescriptor> _servers = new Vector();
    private Set<RemoteServerRegistryListener> _listeners = new HashSet<RemoteServerRegistryListener>();
    private Map<Remote, String> _remoteObjects = new HashMap<Remote, String>();

    private RemoteServerRegistry() {
    }

    public static RemoteServerRegistry instance() {
        if (_instance == null) {
            _instance = new RemoteServerRegistry();
        }
        return _instance;
    }

    public ServerDescriptor connectServer(String string, String string2) throws NotBoundException, RemoteException {
        RemotePlugin.configureInterface();
        Server server = ServerImpl.getInstance(string, string2);
        ServerDescriptor serverDescriptor = new ServerDescriptor(string, string2, server);
        this._servers.add(serverDescriptor);
        this.fireConnectedTo(serverDescriptor);
        return serverDescriptor;
    }

    public void removeServer(int n) {
        ServerDescriptor serverDescriptor = this._servers.get(n);
        this.fireDisconnectedFrom(serverDescriptor);
        this._servers.remove(n);
    }

    public ServerDescriptor getServerDescriptor(int n) {
        return this._servers.elementAt(n);
    }

    public ServerDescriptor[] allServers() {
        return this._servers.toArray(new ServerDescriptor[this._servers.size()]);
    }

    public NetInstanceAccessor[] allNetInstances(int n) throws RemoteException {
        Server server = this.getServer(n);
        return server.getSimulator().getNetInstances();
    }

    public Server getServer(int n) {
        return this._servers.elementAt(n).getServer();
    }

    public void addRegistryListener(RemoteServerRegistryListener remoteServerRegistryListener) {
        this._listeners.add(remoteServerRegistryListener);
    }

    public void catchUpOnPreviousConnects(RemoteServerRegistryListener remoteServerRegistryListener) {
        if (!this._listeners.contains(remoteServerRegistryListener)) {
            throw new IllegalArgumentException("Listener must have been registered before catching up.");
        }
        for (ServerDescriptor serverDescriptor : this._servers) {
            remoteServerRegistryListener.connectedTo(serverDescriptor);
        }
    }

    public boolean registerObjectIfPossible(String string, Remote remote, Properties properties) {
        boolean bl = false;
        try {
            bl = this.registerObject(string, remote, properties);
        }
        catch (RemoteException remoteException) {
            logger.error((Object)("Could not bind " + string + " service to registry: " + String.valueOf(remoteException)));
        }
        return bl;
    }

    public boolean registerObjectIfPossible(String string, Remote remote) {
        PluginProperties pluginProperties = ((SimulatorPlugin)PluginManager.getInstance().getPluginsProviding("de.renew.simulator").iterator().next()).getProperties();
        return this.registerObjectIfPossible(string, remote, (Properties)pluginProperties);
    }

    public boolean registerObject(String string, Remote remote, Properties properties) throws RemoteException {
        boolean bl = false;
        if (PropertyHelper.getBoolProperty((Properties)properties, (String)"de.renew.remote.enable")) {
            String string2 = properties.getProperty("de.renew.remote.publicName");
            Object object = "";
            if (string2 == null) {
                string2 = "default";
            }
            try {
                object = "//localhost/" + string + "." + string2;
                Naming.rebind((String)object, remote);
                logger.info((Object)(string + " service bound to " + (String)object + "."));
                this._remoteObjects.put(remote, (String)object);
                bl = true;
            }
            catch (MalformedURLException malformedURLException) {
                logger.error((Object)("Could not bind " + string + " service to " + (String)object + ": " + String.valueOf(malformedURLException)));
                object = null;
            }
        }
        return bl;
    }

    public boolean registerObject(String string, Remote remote) throws RemoteException {
        PluginProperties pluginProperties = ((SimulatorPlugin)PluginManager.getInstance().getPluginsProviding("de.renew.simulator").iterator().next()).getProperties();
        return this.registerObject(string, remote, (Properties)pluginProperties);
    }

    public void unregisterObject(Remote remote) {
        String string = this._remoteObjects.get(remote);
        if (string != null) {
            try {
                Naming.unbind(string);
            }
            catch (MalformedURLException malformedURLException) {
                logger.error((Object)("Could not unbind object: " + String.valueOf(malformedURLException)));
            }
            catch (RemoteException remoteException) {
                logger.error((Object)("Could not unbind object: " + String.valueOf(remoteException)));
            }
            catch (NotBoundException notBoundException) {
                // empty catch block
            }
            string = null;
        }
    }

    public void removeRegistryListener(RemoteServerRegistryListener remoteServerRegistryListener) {
        this._listeners.remove(remoteServerRegistryListener);
    }

    private void fireConnectedTo(ServerDescriptor serverDescriptor) {
        Iterator<RemoteServerRegistryListener> iterator = this._listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().connectedTo(serverDescriptor);
        }
    }

    private void fireDisconnectedFrom(ServerDescriptor serverDescriptor) {
        Iterator<RemoteServerRegistryListener> iterator = this._listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().disconnectedFrom(serverDescriptor);
        }
    }

    public class ServerDescriptor {
        private String _host;
        private String _name;
        private Server _server;

        public ServerDescriptor(String string, String string2, Server server) {
            this._host = string;
            this._name = string2;
            this._server = server;
        }

        public String getUrl(String string) {
            return "//" + this._host + "/" + string + "." + this._name;
        }

        public String getHost() {
            return this._host;
        }

        public String getName() {
            return this._name;
        }

        public Server getServer() {
            return this._server;
        }

        public String toString() {
            return "//" + this.getHost() + "/" + this.getName();
        }
    }
}

