/*
 * Decompiled with CFR 0.152.
 */
package de.renew.remote;

import de.renew.remote.RemoteObjectHelperObserver;
import de.renew.remote.RemoteServerRegistry;
import de.renew.remote.RemoteServerRegistryListener;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class RemoteObjectHelper
implements RemoteServerRegistryListener {
    public static Logger logger = Logger.getLogger(RemoteObjectHelper.class);
    private String _service;
    private Map<String, Remote> _remoteObjects;
    private Map<String, Object> _localObjects;
    private int _localCounter = 0;
    private Set<RemoteObjectHelperObserver> _observers;

    public RemoteObjectHelper(String string) {
        this._service = string;
        this._remoteObjects = new HashMap<String, Remote>();
        this._observers = new HashSet<RemoteObjectHelperObserver>();
        this._localObjects = new HashMap<String, Object>();
        RemoteServerRegistry remoteServerRegistry = RemoteServerRegistry.instance();
        remoteServerRegistry.addRegistryListener(this);
        remoteServerRegistry.catchUpOnPreviousConnects(this);
    }

    @Override
    public void connectedTo(RemoteServerRegistry.ServerDescriptor serverDescriptor) {
        Remote remote = null;
        String string = serverDescriptor.getUrl(this._service);
        try {
            remote = Naming.lookup(string);
            this._remoteObjects.put(string, remote);
            logger.info((Object)("Found service " + this._service + " on " + string));
            this.fireNotifyObjectAdded(string, remote);
        }
        catch (RemoteException remoteException) {
            logger.error((Object)("Could not lookup service " + this._service + " on " + string + ".\nException:\n" + remoteException.getMessage()), (Throwable)remoteException);
        }
        catch (MalformedURLException malformedURLException) {
            logger.error((Object)("Could not lookup service " + this._service + " on " + string + ".\nException:\n" + malformedURLException.getMessage()), (Throwable)malformedURLException);
        }
        catch (NotBoundException notBoundException) {
            // empty catch block
        }
    }

    @Override
    public void disconnectedFrom(RemoteServerRegistry.ServerDescriptor serverDescriptor) {
        String string = serverDescriptor.getUrl(this._service);
        if (this._remoteObjects.remove(string) != null) {
            this.fireNotifyObjectRemoved(string);
        }
    }

    public String addLocalObject(Object object) {
        String string = "local" + this._localCounter++;
        this._localObjects.put(string, object);
        this.fireNotifyObjectAdded(string, object);
        return string;
    }

    public void removeLocalObjectByIdentifier(String string) {
        this._localObjects.remove(string);
        this.fireNotifyObjectRemoved(string);
    }

    public void removeLocalObject(Object object) {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (String string : this._localObjects.keySet()) {
            Object object2 = this._localObjects.get(string);
            if ((object != null || object2 != null) && (object == null || !object.equals(object2))) continue;
            linkedList.add(string);
        }
        for (String string : linkedList) {
            this.fireNotifyObjectRemoved(string);
            this._localObjects.remove(string);
        }
    }

    public Map<String, Object> getObjects() {
        Map<String, Object> map = this.getRemoteObjects();
        map.putAll(this.getLocalObjects());
        return map;
    }

    public Map<String, Object> getRemoteObjects() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(this._remoteObjects);
        return hashMap;
    }

    public Map<String, Object> getLocalObjects() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(this._localObjects);
        return hashMap;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        RemoteServerRegistry.instance().removeRegistryListener(this);
    }

    public void addObserver(RemoteObjectHelperObserver remoteObjectHelperObserver) {
        this._observers.add(remoteObjectHelperObserver);
    }

    public void removeObserver(RemoteObjectHelperObserver remoteObjectHelperObserver) {
        this._observers.remove(remoteObjectHelperObserver);
    }

    protected void fireNotifyObjectAdded(String string, Object object) {
        for (RemoteObjectHelperObserver remoteObjectHelperObserver : this._observers) {
            remoteObjectHelperObserver.notifyObjectAdded(string, object);
        }
    }

    protected void fireNotifyObjectRemoved(String string) {
        for (RemoteObjectHelperObserver remoteObjectHelperObserver : this._observers) {
            remoteObjectHelperObserver.notifyObjectRemoved(string);
        }
    }
}

