/*
 * Decompiled with CFR 0.152.
 */
package de.renew.ant;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Mkdir;
import org.apache.tools.ant.types.FileSet;

public abstract class AbstractEnhancedJavaCCTask
extends Task {
    protected File javacchome;
    protected File destdir;
    protected FileSet fileset;
    protected File srcbase;
    protected String singleTaskName;

    public AbstractEnhancedJavaCCTask(String string) {
        this.singleTaskName = string;
    }

    public void init() throws BuildException {
        super.init();
    }

    public void setDestdir(File file) {
        this.destdir = file;
    }

    public void setJavacchome(File file) {
        this.javacchome = file;
    }

    public void addConfiguredFileset(FileSet fileSet) {
        this.fileset = fileSet;
        this.srcbase = fileSet.getDir(this.getProject());
    }

    public void setSrcbase(File file) {
        this.srcbase = file;
    }

    public void execute() throws BuildException {
        DirectoryScanner directoryScanner = this.fileset.getDirectoryScanner(this.getProject());
        String[] stringArray = directoryScanner.getIncludedFiles();
        File file = directoryScanner.getBasedir();
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(file.getAbsolutePath() + File.separator + stringArray[i]);
            if (!file2.isFile()) {
                throw new BuildException("javacc-File " + String.valueOf(file2) + " does not exist!");
            }
            this.mkdirAndExecuteJavaCC(file2);
        }
    }

    protected void mkdirAndExecuteJavaCC(File file) throws BuildException {
        File file2 = this.getGenerationDirectory(file);
        if (!file2.isDirectory()) {
            Mkdir mkdir = (Mkdir)this.getProject().createTask("mkdir");
            mkdir.setDir(file2);
            mkdir.init();
            mkdir.execute();
        }
        this.executeJavaCC(file, file2);
    }

    protected abstract void executeJavaCC(File var1, File var2) throws BuildException;

    protected File getGenerationDirectory(File file) {
        String string = file.getParent();
        String string2 = string.substring(this.srcbase.getAbsolutePath().length());
        File file2 = new File(this.destdir.getAbsolutePath() + File.separator + string2);
        return file2;
    }
}

