/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.io;

import CH.ifa.draw.io.SimpleFileFilter;
import java.io.File;
import java.io.FileFilter;
import java.util.Collection;
import java.util.HashSet;

public class CombinationFileFilter
extends SimpleFileFilter
implements FileFilter {
    private final HashSet<SimpleFileFilter> filterList = new HashSet();
    private SimpleFileFilter preferredFileFilter;
    private String description;
    private boolean allowDirectory = true;
    private boolean allowHidden = false;

    public CombinationFileFilter(String string) {
        this.setDescription(string);
    }

    @Override
    public void setDescription(String string) {
        this.description = string;
    }

    public boolean add(SimpleFileFilter simpleFileFilter) {
        boolean bl = false;
        if (!this.contains(simpleFileFilter)) {
            if (this.filterList.isEmpty()) {
                this.preferredFileFilter = simpleFileFilter;
            }
            bl = this.filterList.add(simpleFileFilter);
        }
        return bl;
    }

    public boolean addAll(Collection<SimpleFileFilter> collection) {
        boolean bl = false;
        for (SimpleFileFilter simpleFileFilter : collection) {
            bl = this.add(simpleFileFilter) || bl;
        }
        return bl;
    }

    public boolean contains(SimpleFileFilter simpleFileFilter) {
        boolean bl = false;
        for (SimpleFileFilter simpleFileFilter2 : this.filterList) {
            if (simpleFileFilter == null || !simpleFileFilter.equals(simpleFileFilter2)) continue;
            bl = true;
        }
        return bl;
    }

    public void remove(SimpleFileFilter simpleFileFilter) {
        this.filterList.remove(simpleFileFilter);
    }

    public HashSet<SimpleFileFilter> getFileFilters() {
        return this.filterList;
    }

    @Override
    public String getExtension() {
        return this.getPreferedFileFilter().getExtension();
    }

    @Override
    public void allowHidden(boolean bl) {
        this.allowHidden = bl;
    }

    @Override
    public void allowDirectory(boolean bl) {
        this.allowDirectory = bl;
    }

    @Override
    public boolean isHiddenAllowed() {
        return this.allowHidden;
    }

    @Override
    public boolean isDirectoryAllowed() {
        return this.allowDirectory;
    }

    @Override
    public boolean accept(File file) {
        if (file == null) {
            return false;
        }
        if (!this.allowHidden && (file.isHidden() || file.getName().startsWith("."))) {
            return false;
        }
        if (file.isDirectory()) {
            return this.allowDirectory;
        }
        for (SimpleFileFilter simpleFileFilter : this.filterList) {
            if (!simpleFileFilter.accept(file)) continue;
            return true;
        }
        return false;
    }

    public SimpleFileFilter getPreferedFileFilter() {
        return this.preferredFileFilter;
    }

    public void setPreferedFileFilter(SimpleFileFilter simpleFileFilter) {
        this.preferredFileFilter = simpleFileFilter;
    }

    public boolean isEmpty() {
        return this.filterList.isEmpty();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof CombinationFileFilter) {
            CombinationFileFilter combinationFileFilter = (CombinationFileFilter)object;
            if (this.getDescription().equals(combinationFileFilter.getDescription()) && this.getFileFilters().equals(combinationFileFilter.getFileFilters())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return CombinationFileFilter.class.hashCode() ^ this.getDescription().hashCode() ^ this.getFileFilters().hashCode();
    }
}

