/*
 * Decompiled with CFR 0.152.
 */
package de.renew.io.exportFormats;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.io.exportFormats.ExportFormat;
import de.renew.io.exportFormats.EPSExportFormat;
import de.renew.io.exportFormats.ExportClCommand;
import de.renew.io.exportFormats.PDFExportFormat;
import de.renew.io.exportFormats.PNGExportFormat;
import de.renew.io.exportFormats.SVGExportFormat;
import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginException;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.command.CLCommand;
import java.net.URL;
import org.apache.log4j.Logger;
import org.freehep.graphicsio.PageConstants;

public class ExportPlugin
extends PluginAdapter {
    public static Logger logger = Logger.getLogger(ExportPlugin.class);
    public static String NO_EMEDED_FONTS_PROPERTY = "de.renew.io.exportFormats.svg-no-embeded-fonts";
    private EPSExportFormat epsExport;
    private PDFExportFormat pdfExport;
    private SVGExportFormat svgExport;
    private PNGExportFormat pngExport;
    public static final String PAGE_SIZE_PROP_NAME = "de.renew.io.export.pageSize";
    public static final String PAGE_ORIENTATION_PROP_NAME = "de.renew.io.export.pageOrientation";
    public static final String PAGE_MARGINS_PROP_NAME = "de.renew.io.export.pageMargins";
    public static final String EPS_FONT_HANDLING_PROP_NAME = "de.renew.io.export.epsFontHandling";
    public static final String EPS_FONT_HANDLING_EMBED = "embed";
    public static final String EPS_FONT_HANDLING_NONE = "none";
    public static final String EPS_FONT_HANDLING_SHAPES = "shapes";
    public static final String[] EPS_FONT_HANDLING_PROP_VALUES = new String[]{"embed", "none", "shapes"};
    private static final String EPS_TRANSPARENCY_PROP_NAME = "de.renew.io.export.eps-transparency";
    public static final String BOUNDING_BOX_PAGE_SIZE = "BoundingBox";

    public ExportPlugin(URL uRL) throws PluginException {
        super(uRL);
    }

    public ExportPlugin(PluginProperties pluginProperties) {
        super(pluginProperties);
    }

    public boolean cleanup() {
        DrawPlugin drawPlugin = DrawPlugin.getCurrent();
        if (drawPlugin == null) {
            return true;
        }
        drawPlugin.getExportHolder().removeExportFormat((ExportFormat)this.epsExport);
        drawPlugin.getExportHolder().removeExportFormat((ExportFormat)this.pdfExport);
        drawPlugin.getExportHolder().removeExportFormat((ExportFormat)this.svgExport);
        drawPlugin.getExportHolder().removeExportFormat((ExportFormat)this.pngExport);
        PluginManager.getInstance().removeCLCommand("ex");
        return true;
    }

    public String getAlias() {
        return "export";
    }

    public void init() {
        DrawPlugin drawPlugin = DrawPlugin.getCurrent();
        if (drawPlugin == null) {
            return;
        }
        this.epsExport = new EPSExportFormat();
        this.pdfExport = new PDFExportFormat();
        this.svgExport = new SVGExportFormat();
        this.pngExport = new PNGExportFormat();
        drawPlugin.getExportHolder().addExportFormat((ExportFormat)this.epsExport);
        drawPlugin.getExportHolder().addExportFormat((ExportFormat)this.pdfExport);
        drawPlugin.getExportHolder().addExportFormat((ExportFormat)this.svgExport);
        drawPlugin.getExportHolder().addExportFormat((ExportFormat)this.pngExport);
        PluginManager.getInstance().addCLCommand("ex", (CLCommand)new ExportClCommand());
    }

    public static ExportPlugin getCurrent() {
        for (Object e : PluginManager.getInstance().getPluginsProviding("de.renew.io.export")) {
            if (!(e instanceof ExportPlugin)) continue;
            return (ExportPlugin)((Object)e);
        }
        return null;
    }

    public String getPageSize() {
        String string = BOUNDING_BOX_PAGE_SIZE;
        String string2 = this.getProperties().getProperty(PAGE_SIZE_PROP_NAME, "A4");
        logger.debug((Object)("Page Size user = " + string2));
        for (String string3 : PageConstants.getSizeList()) {
            if (!string3.equalsIgnoreCase(string2)) continue;
            string = string3;
            this.getProperties().setProperty(PAGE_SIZE_PROP_NAME, string3);
            break;
        }
        if (string2.equalsIgnoreCase(BOUNDING_BOX_PAGE_SIZE)) {
            string = BOUNDING_BOX_PAGE_SIZE;
            this.getProperties().setProperty(PAGE_SIZE_PROP_NAME, BOUNDING_BOX_PAGE_SIZE);
        }
        logger.debug((Object)("Page Size = " + string));
        return string;
    }

    public String getPageOrientation() {
        String string = "Portrait";
        String string2 = this.getProperties().getProperty(PAGE_ORIENTATION_PROP_NAME, "Portrait");
        logger.debug((Object)("Page orientation user = " + string2));
        if (string2.equalsIgnoreCase("Portrait")) {
            string = "Portrait";
            this.getProperties().setProperty(PAGE_ORIENTATION_PROP_NAME, string);
        } else if (string2.equalsIgnoreCase("Landscape")) {
            string = "Landscape";
            this.getProperties().setProperty(PAGE_ORIENTATION_PROP_NAME, string);
        }
        logger.debug((Object)("Page orientation = " + string));
        return string;
    }

    public String getEpsFontHandling() {
        String string = EPS_FONT_HANDLING_SHAPES;
        String string2 = this.getProperties().getProperty(EPS_FONT_HANDLING_PROP_NAME, EPS_FONT_HANDLING_SHAPES);
        logger.debug((Object)("EPS font handling user = " + string2));
        for (String string3 : EPS_FONT_HANDLING_PROP_VALUES) {
            if (!string3.equalsIgnoreCase(string2)) continue;
            string = string3;
            this.getProperties().setProperty(EPS_FONT_HANDLING_PROP_NAME, string);
            break;
        }
        logger.debug((Object)("EPS font handling = " + string));
        return string;
    }

    public boolean getEpsTransparency() {
        boolean bl = this.getProperties().getBoolProperty(EPS_TRANSPARENCY_PROP_NAME);
        logger.debug((Object)("EPS tansparency user = " + bl));
        return bl;
    }
}

