/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator.vc.impl;

import de.renew.navigator.vc.Repository;
import de.renew.navigator.vc.VersionControl;
import de.renew.navigator.vc.VersionControlAggregator;
import java.io.File;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class VersionControlAggregatorImpl
implements VersionControlAggregator {
    public static final Logger logger = Logger.getLogger(VersionControlAggregatorImpl.class);
    private final LinkedList<VersionControl> versionControls = new LinkedList();

    @Override
    public void addVersionControl(VersionControl versionControl) {
        this.versionControls.add(versionControl);
    }

    @Override
    public boolean removeVersionControl(VersionControl versionControl) {
        return this.versionControls.remove(versionControl);
    }

    @Override
    public boolean controls(File file) {
        for (VersionControl versionControl : this.versionControls) {
            if (!versionControl.controls(file)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean diff(File file) {
        Repository repository = this.findRepository(file);
        if (repository == null) {
            this.warnNotInARepository(file);
            return false;
        }
        return repository.getVersionControl().diff(file);
    }

    @Override
    public boolean log(File file) {
        Repository repository = this.findRepository(file);
        if (repository == null) {
            this.warnNotInARepository(file);
            return false;
        }
        return repository.getVersionControl().log(file);
    }

    @Override
    public String getName() {
        StringBuilder stringBuilder = new StringBuilder("[");
        boolean bl = true;
        for (VersionControl versionControl : this.versionControls) {
            if (!bl) {
                stringBuilder.append(',');
            } else {
                bl = false;
            }
            stringBuilder.append(versionControl.getName());
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public Repository findRepository(File file) {
        for (VersionControl versionControl : this.versionControls) {
            if (!versionControl.controls(file)) continue;
            return versionControl.findRepository(file);
        }
        this.warnNotInARepository(file);
        return null;
    }

    private void warnNotInARepository(File file) {
        logger.warn((Object)("The file " + file.getAbsolutePath() + " seems not to be in a repository known to " + this.getName()));
    }
}

