/*
 * Decompiled with CFR 0.152.
 */
package de.renew.fa.figures;

import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.figures.ChopEllipseConnector;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.standard.BoxHandleKit;
import CH.ifa.draw.util.Geom;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Vector;

public class HalfMoonFigure
extends AttributeFigure {
    static final long serialVersionUID = -6856203289355118951L;
    private Rectangle fDisplayBox;

    public HalfMoonFigure() {
        this(new Point(0, 0), new Point(0, 0));
    }

    public HalfMoonFigure(Point point, Point point2) {
        this.basicDisplayBox(point, point2);
    }

    public void basicDisplayBox(Point point, Point point2) {
        this.fDisplayBox = new Rectangle(point);
        this.fDisplayBox.add(point2);
    }

    protected void basicMoveBy(int n, int n2) {
        this.fDisplayBox.translate(n, n2);
    }

    public Insets connectionInsets() {
        Rectangle rectangle = this.fDisplayBox;
        int n = rectangle.width / 2;
        int n2 = rectangle.height / 2;
        return new Insets(n2, n, n2, n);
    }

    public Connector connectorAt(int n, int n2) {
        return new ChopEllipseConnector((Figure)this);
    }

    public boolean containsPoint(int n, int n2) {
        if (super.containsPoint(n, n2)) {
            return Geom.ellipseContainsPoint((Rectangle)this.displayBox(), (int)n, (int)n2);
        }
        return false;
    }

    public Rectangle displayBox() {
        return new Rectangle(this.fDisplayBox.x, this.fDisplayBox.y, this.fDisplayBox.width, this.fDisplayBox.height);
    }

    public void drawBackground(Graphics graphics) {
        Rectangle rectangle = this.displayBox();
        graphics.fillArc(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1, 120, 120);
        graphics.setColor(Color.white);
        graphics.fillRect(this.getXabs() + this.displayBox().width / 4, this.getYabs(), new Double(this.displayBox().width / 2).intValue(), new Double(this.getYprime() * 2.0).intValue());
    }

    public void drawFrame(Graphics graphics) {
        Rectangle rectangle = this.displayBox();
        graphics.drawArc(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1, 120, 120);
        graphics.drawLine(this.getXabs() + this.displayBox().width / 4, this.getYabs(), this.getXabs() + this.displayBox().width / 4, new Double(this.getYprime() * 2.0).intValue());
    }

    private int getXabs() {
        return this.displayBox().x;
    }

    private int getYabs() {
        float f = this.displayBox().height / 2;
        return new Double((double)((float)this.displayBox().y + f) - this.getYprime()).intValue();
    }

    private double getYprime() {
        float f = this.displayBox().height / 2;
        return Math.sqrt(0.75 * (double)f * (double)f);
    }

    public Vector<Handle> handles() {
        Vector<Handle> vector = new Vector<Handle>();
        BoxHandleKit.addHandles((Figure)this, vector);
        return vector;
    }

    public void read(StorableInput storableInput) throws IOException {
        super.read(storableInput);
        this.fDisplayBox = new Rectangle(storableInput.readInt(), storableInput.readInt(), storableInput.readInt(), storableInput.readInt());
    }

    public void write(StorableOutput storableOutput) {
        super.write(storableOutput);
        storableOutput.writeInt(this.fDisplayBox.x);
        storableOutput.writeInt(this.fDisplayBox.y);
        storableOutput.writeInt(this.fDisplayBox.width);
        storableOutput.writeInt(this.fDisplayBox.height);
    }
}

