/*
 * Decompiled with CFR 0.152.
 */
package org.gitective.core.filter.tree;

import java.io.IOException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.gitective.core.filter.commit.CommitFilter;
import org.gitective.core.filter.tree.BaseTreeFilter;

public class CommitParentTreeFilter
extends CommitFilter {
    private final BaseTreeFilter filter;

    public CommitParentTreeFilter(TreeFilter filter) {
        this.filter = BaseTreeFilter.wrap(filter);
    }

    public CommitFilter setRepository(Repository repository) {
        this.filter.setRepository(repository);
        return super.setRepository(repository);
    }

    public CommitFilter reset() {
        this.filter.reset();
        return super.reset();
    }

    public boolean include(RevWalk walker, RevCommit commit) throws IOException {
        TreeWalk walk = new TreeWalk(walker.getObjectReader());
        walk.addTree((AnyObjectId)commit.getTree());
        RevTree tree = null;
        for (RevCommit parent : commit.getParents()) {
            tree = parent.getTree();
            if (tree == null) {
                walker.parseHeaders((RevObject)parent);
                tree = parent.getTree();
            }
            walk.addTree((AnyObjectId)tree);
        }
        while (walk.next()) {
            if (this.filter.include(walker, commit, walk)) {
                return true;
            }
            if (!walk.isSubtree()) continue;
            walk.enterSubtree();
        }
        return this.include(false);
    }

    public RevFilter clone() {
        return new CommitParentTreeFilter(this.filter);
    }
}

