/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator.gui;

import de.renew.navigator.NavigatorAction;
import de.renew.navigator.gui.NavigatorGuiImpl;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.KeyStroke;

class TreeKeyListener
implements KeyListener {
    private NavigatorGuiImpl gui = null;

    public TreeKeyListener(NavigatorGuiImpl navigatorGuiImpl) {
        this.gui = navigatorGuiImpl;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 0) {
            return;
        }
        if (this.checkActionAccelerators(keyEvent)) {
            return;
        }
        switch (keyEvent.getKeyCode()) {
            case 10: 
            case 30: {
                this.gui.openSelected();
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    private boolean checkActionAccelerators(KeyEvent keyEvent) {
        for (NavigatorAction navigatorAction : this.gui.getActions()) {
            boolean bl;
            KeyStroke keyStroke = (KeyStroke)navigatorAction.getValue("AcceleratorKey");
            if (keyStroke == null) continue;
            boolean bl2 = (1 & keyStroke.getModifiers()) == 0 || keyEvent.isShiftDown();
            boolean bl3 = bl = (2 & keyStroke.getModifiers()) == 0 || keyEvent.isControlDown();
            if (keyStroke.getKeyCode() != keyEvent.getKeyCode() || !bl2 || !bl) continue;
            navigatorAction.actionPerformed(null);
            return true;
        }
        return false;
    }
}

