/*
 * Decompiled with CFR 0.152.
 */
package de.renew.util;

import java.util.LinkedList;

public class RunQueue
implements Runnable {
    private LinkedList<Runnable> runnables = new LinkedList();
    private boolean terminated = false;

    public boolean isTerminated() {
        return this.terminated;
    }

    public synchronized void add(Runnable runnable) {
        if (!this.terminated) {
            this.runnables.addFirst(runnable);
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.terminated) {
            RunQueue runQueue = this;
            synchronized (runQueue) {
                if (Thread.currentThread().isInterrupted()) {
                    this.terminated = true;
                } else if (this.runnables.isEmpty()) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        this.terminated = true;
                    }
                } else {
                    Runnable runnable = this.runnables.removeLast();
                    runnable.run();
                }
            }
        }
    }
}

