/*
 * Decompiled with CFR 0.152.
 */
package de.renew.rnrg.elements;

import de.renew.engine.searcher.Finder;
import de.renew.engine.searcher.Searchable;
import de.renew.engine.searcher.Searcher;
import de.renew.engine.simulator.Binding;
import de.renew.engine.simulator.GraphFinder;
import de.renew.net.Net;
import de.renew.net.NetInstance;
import de.renew.net.ResettableNetInstance;
import de.renew.net.Transition;
import de.renew.rnrg.elements.InscribedEdge;
import de.renew.rnrg.elements.NetInstanceState;
import de.renew.rnrg.elements.Node;
import de.renew.unify.Impossible;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class NodeImpl
extends Node {
    private static Logger logger = Logger.getLogger(NodeImpl.class);
    private static final long serialVersionUID = 0L;
    private final NetInstanceState rootInstanceState;
    private final Set<ResettableNetInstance> instances;
    private final long depth;

    public NodeImpl(Set<ResettableNetInstance> set, NetInstanceState netInstanceState) {
        this(set, netInstanceState, 0L);
    }

    private NodeImpl(Set<ResettableNetInstance> set, NetInstanceState netInstanceState, long l) {
        this.rootInstanceState = netInstanceState;
        this.instances = set;
        this.depth = l;
    }

    public NodeImpl(Net net) {
        this.rootInstanceState = new NetInstanceState(net);
        this.instances = Collections.singleton(this.rootInstanceState.instance);
        this.depth = 0L;
    }

    public int hashCode() {
        return this.rootInstanceState.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof NodeImpl && this.rootInstanceState.equals(((NodeImpl)object).rootInstanceState);
    }

    private Node addIfNonexistent(Map<NetInstanceState, Node> map, Collection<NodeImpl> collection) {
        Node node = map.get(this.rootInstanceState);
        if (node != null) {
            return node;
        }
        this.addTo(map);
        collection.add(this);
        return this;
    }

    public void addTo(Map<NetInstanceState, Node> map) {
        map.put(this.rootInstanceState, this);
    }

    private NodeImpl successorFromCurrentState() {
        Object object;
        HashMap<NetInstance, ResettableNetInstance> hashMap = new HashMap<NetInstance, ResettableNetInstance>(this.instances.size());
        for (NetInstance object32 : this.instances) {
            try {
                hashMap.put(object32, new ResettableNetInstance(object32.getNet(), false));
            }
            catch (Impossible serializable) {
                throw new RuntimeException(serializable);
            }
        }
        NetInstance netInstance = this.rootInstanceState.getNetInstance();
        HashSet<NetInstance> hashSet = new HashSet<NetInstance>();
        Serializable serializable = new HashSet<NetInstance>();
        serializable.add(netInstance);
        while (!serializable.isEmpty()) {
            Object object2 = serializable.iterator();
            object = (NetInstance)object2.next();
            object2.remove();
            hashSet.add((NetInstance)object);
            object2 = ((ResettableNetInstance)((Object)hashMap.get(object))).setTo((NetInstance)object, hashMap);
            object2.removeAll(hashSet);
            serializable.addAll(object2);
        }
        serializable = new NetInstanceState((ResettableNetInstance)((Object)hashMap.get(netInstance)));
        object = new HashSet(hashSet.size());
        for (NetInstance netInstance2 : hashSet) {
            object.add((ResettableNetInstance)((Object)hashMap.get(netInstance2)));
        }
        return new NodeImpl((Set<ResettableNetInstance>)object, (NetInstanceState)serializable, this.depth + 1L);
    }

    private NodeImpl exploreBinding(Binding binding, Map<NetInstance, ResettableNetInstance> map) {
        binding.execute(null, false);
        NodeImpl nodeImpl = this.successorFromCurrentState();
        this.resetToBackup(map);
        return nodeImpl;
    }

    public boolean exploreEdges(long l, GraphFinder.TransitionChecker transitionChecker, Map<NetInstanceState, Node> map, Collection<NodeImpl> collection) {
        boolean bl = false;
        this.edges = new HashSet();
        Map<NetInstance, ResettableNetInstance> map2 = this.createBackup();
        if (l == this.depth) {
            transitionChecker = new GraphFinder.TransitionChecker(){

                @Override
                public boolean isExplorable(Transition transition) {
                    return false;
                }
            };
            bl = true;
        }
        for (NetInstance netInstance : this.instances) {
            for (Transition transition : netInstance.getNet().transitions()) {
                String string;
                String string2 = netInstance == this.rootInstanceState.instance ? transition.toString() : netInstance.getInstance(transition).toString();
                GraphFinder graphFinder = new GraphFinder(transitionChecker);
                new Searcher().searchAndRecover((Finder)graphFinder, (Searchable)netInstance.getInstance(transition), null);
                for (Binding binding : graphFinder.unexplorableBindings()) {
                    string = binding.getDescription();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("not exploring: " + string));
                    }
                    this.edges.add(new InscribedEdge(string2, string, null));
                }
                for (Binding binding : graphFinder.explorableBindings()) {
                    string = binding.getDescription();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("exploring: " + string));
                    }
                    Node node = this.exploreBinding(binding, map2).addIfNonexistent(map, collection);
                    node.addPredecessor(this);
                    this.edges.add(new InscribedEdge(string2, string, node));
                }
            }
        }
        return bl;
    }

    private Map<NetInstance, ResettableNetInstance> createBackup() {
        HashMap<NetInstance, ResettableNetInstance> hashMap = new HashMap<NetInstance, ResettableNetInstance>(this.instances.size());
        for (ResettableNetInstance resettableNetInstance : this.instances) {
            hashMap.put((NetInstance)resettableNetInstance, resettableNetInstance.copy());
        }
        return hashMap;
    }

    private void resetToBackup(Map<NetInstance, ResettableNetInstance> map) {
        for (ResettableNetInstance resettableNetInstance : this.instances) {
            resettableNetInstance.setTo((NetInstance)map.get((Object)resettableNetInstance));
        }
    }

    @Override
    public Collection<? extends NetInstance> getNetInstances() {
        return this.instances;
    }

    @Override
    public NetInstance getRootNetInstance() {
        return this.rootInstanceState.getNetInstance();
    }

    @Override
    public long getDepth() {
        return this.depth;
    }
}

