/*
 * Decompiled with CFR 0.152.
 */
package de.renew.rnrg.commands;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.util.Command;
import de.renew.net.TransitionCheckerImpl;
import de.renew.rnrg.commands.ReachabilityGraphClCommand;
import de.renew.rnrg.elements.Graph;
import de.renew.rnrg.gui.GraphDrawing;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class ReachabilityGraphCommand
extends Command
implements Runnable {
    public static Logger logger = Logger.getLogger(ReachabilityGraphCommand.class);
    public static final String CMD_NAME = "Ref Net Reachability Graph...";
    private static final String FRAME_NAME = "Graph Creation";
    private JFrame frame;
    private boolean action = true;
    private boolean creation = false;
    private int inscMode;
    private boolean limitDepth = false;
    private long maxDepth = 16L;
    private GUIAborter aborter;

    public ReachabilityGraphCommand() {
        super(CMD_NAME);
    }

    public void execute() {
        this.createFrame();
    }

    private void start() {
        new Thread(this).start();
    }

    private void createFrame() {
        this.frame = new JFrame(FRAME_NAME);
        this.aborter = new GUIAborter();
        final JCheckBox jCheckBox = new JCheckBox("Skip Action Execution", this.action);
        jCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ReachabilityGraphCommand.this.action = itemEvent.getStateChange() == 1;
            }
        });
        jCheckBox.setToolTipText("Do not explore bindings that would fire transitions with action inscriptions.");
        final JCheckBox jCheckBox2 = new JCheckBox("Skip Net Instance Creation", this.creation);
        jCheckBox2.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ReachabilityGraphCommand.this.creation = itemEvent.getStateChange() == 1;
            }
        });
        jCheckBox2.setToolTipText("Do not explore bindings that would create new net instances.");
        final JComboBox<String> jComboBox = new JComboBox<String>(GraphDrawing.INSC_MODES);
        jComboBox.setSelectedIndex(this.inscMode);
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReachabilityGraphCommand.this.inscMode = jComboBox.getSelectedIndex();
            }
        });
        jComboBox.setToolTipText("What to inscribe to graph nodes.");
        final JFormattedTextField jFormattedTextField = new JFormattedTextField(this.maxDepth);
        jFormattedTextField.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent jComponent) {
                JFormattedTextField.AbstractFormatter abstractFormatter = jFormattedTextField.getFormatter();
                try {
                    Object object = abstractFormatter.stringToValue(jFormattedTextField.getText());
                    if (object instanceof Long && (Long)object >= 0L) {
                        return true;
                    }
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                return false;
            }
        });
        jFormattedTextField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ReachabilityGraphCommand.this.maxDepth = (Long)jFormattedTextField.getValue();
            }
        });
        jFormattedTextField.setEnabled(this.limitDepth);
        jFormattedTextField.setHorizontalAlignment(11);
        jFormattedTextField.setToolTipText("Maximum depth up to which graph nodes are explored.");
        JCheckBox jCheckBox3 = new JCheckBox("Depth Limit", this.limitDepth);
        jCheckBox3.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ReachabilityGraphCommand.this.limitDepth = itemEvent.getStateChange() == 1;
                jFormattedTextField.setEnabled(ReachabilityGraphCommand.this.limitDepth);
            }
        });
        jCheckBox3.setToolTipText("Stop exploring graph nodes after reaching this depth.");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(jCheckBox);
        jPanel.add(jCheckBox2);
        jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "Node Inscriptions"));
        jPanel2.add(jComboBox);
        ReachabilityGraphCommand.limitMaxHeight(jComboBox);
        jComboBox.setAlignmentX(0.0f);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(jCheckBox3);
        jPanel3.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel3.add(jFormattedTextField);
        jPanel3.add(Box.createRigidArea(new Dimension(5, 0)));
        ReachabilityGraphCommand.limitMaxHeight(jFormattedTextField);
        jPanel3.setAlignmentX(0.0f);
        jPanel.add(jPanel3);
        jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        final JButton jButton = new JButton("Start");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jButton.setEnabled(false);
                jCheckBox.setEnabled(false);
                jCheckBox2.setEnabled(false);
                ReachabilityGraphCommand.this.start();
            }
        });
        this.frame.getRootPane().setDefaultButton(jButton);
        jButton.setToolTipText("Start the reachability graph creation.");
        AbstractAction abstractAction = new AbstractAction("Cancel"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReachabilityGraphCommand.this.closeFrame();
            }
        };
        JButton jButton2 = new JButton(abstractAction);
        jButton2.setToolTipText("Cancel reachability graph creation and close window.");
        jButton2.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "cancel");
        jButton2.getActionMap().put("cancel", abstractAction);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ReachabilityGraphCommand.this.closeFrame();
            }
        });
        JPanel jPanel4 = new JPanel(new GridLayout(1, 0));
        jPanel4.add(jButton2);
        jPanel4.add(jButton);
        Container container = this.frame.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        jPanel.setAlignmentX(0.5f);
        jPanel4.setAlignmentX(0.5f);
        jPanel4.setMaximumSize(jPanel4.getPreferredSize());
        container.add(Box.createGlue());
        container.add(jPanel);
        container.add(Box.createGlue());
        container.add(jPanel4);
        this.frame.pack();
        ReachabilityGraphCommand.setMaxWidth(jPanel2, jCheckBox2.getSize().width);
        ReachabilityGraphCommand.setMaxWidth(jPanel3, jCheckBox2.getSize().width);
        this.frame.setAlwaysOnTop(true);
        this.frame.pack();
        jButton.requestFocusInWindow();
        DrawPlugin.getCurrent().getMenuManager().getWindowsMenu().addFrame("Tools", (Frame)this.frame);
        this.frame.setVisible(true);
    }

    private static void limitMaxHeight(JComponent jComponent) {
        jComponent.setMaximumSize(new Dimension(jComponent.getMaximumSize().width, jComponent.getPreferredSize().height));
    }

    private static void setMaxWidth(JComponent jComponent, int n) {
        jComponent.setMaximumSize(new Dimension(n, jComponent.getMaximumSize().height));
    }

    private synchronized void closeFrame() {
        if (this.frame != null) {
            this.aborter.initiateAbort();
            this.frame.setVisible(false);
            DrawPlugin.getCurrent().getMenuManager().getWindowsMenu().removeFrame((Frame)this.frame);
            this.frame = null;
            this.aborter = null;
        }
    }

    @Override
    public void run() {
        String string = ReachabilityGraphClCommand.createGraph(null, this.inscMode, this.limitDepth ? this.maxDepth : -1L, new TransitionCheckerImpl(this.action, this.creation), this.aborter);
        this.closeFrame();
        if (!string.isEmpty()) {
            logger.error((Object)("creating reachability graph: " + string));
        }
    }

    private class GUIAborter
    implements Graph.Aborter {
        private boolean abort = false;

        private GUIAborter() {
        }

        void initiateAbort() {
            this.abort = true;
        }

        @Override
        public boolean abort() {
            return this.abort;
        }
    }
}

