/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.simulator;

import de.renew.engine.searcher.Finder;
import de.renew.engine.searcher.Occurrence;
import de.renew.engine.searcher.Searcher;
import de.renew.engine.simulator.Binding;
import de.renew.net.Transition;
import de.renew.net.TransitionOccurrence;
import java.util.ArrayList;
import java.util.Collection;

public class GraphFinder
implements Finder {
    private final TransitionChecker checker;
    private Collection<Binding> explorableBindings = new ArrayList<Binding>();
    private Collection<Binding> unexplorableBindings = new ArrayList<Binding>();

    public GraphFinder(TransitionChecker transitionChecker) {
        this.checker = transitionChecker;
    }

    public void found(Searcher searcher) {
        for (Occurrence occurrence : searcher.getOccurrences()) {
            if (!(occurrence instanceof TransitionOccurrence) || this.checker.isExplorable(((TransitionOccurrence)occurrence).getTransition().getTransition())) continue;
            this.unexplorableBindings.add(new Binding(searcher));
            return;
        }
        this.explorableBindings.add(new Binding(searcher));
    }

    public boolean isCompleted() {
        return false;
    }

    public Collection<Binding> explorableBindings() {
        return this.explorableBindings;
    }

    public Collection<Binding> unexplorableBindings() {
        return this.unexplorableBindings;
    }

    public static interface TransitionChecker {
        public boolean isExplorable(Transition var1);
    }
}

