/*
 * Decompiled with CFR 0.152.
 */
package de.renew.unify;

import de.renew.unify.Calculator;
import de.renew.unify.Impossible;
import de.renew.unify.Notifiable;
import de.renew.unify.Reference;
import de.renew.unify.Referer;
import de.renew.unify.StateRecorder;
import de.renew.unify.Unify;
import de.renew.util.Types;
import de.renew.util.Value;
import java.util.Set;
import org.apache.log4j.Logger;

public class TypeConstrainer
implements Referer {
    public static Logger logger = Logger.getLogger(TypeConstrainer.class);
    final Class<?> type;
    private final Reference reference;

    private TypeConstrainer(Class<?> clazz, Object object, StateRecorder stateRecorder) throws Impossible {
        this.type = clazz;
        this.reference = new Reference(object, this, stateRecorder);
    }

    public static void constrain(Class<?> clazz, Object object, StateRecorder stateRecorder) throws Impossible {
        if (clazz == Types.UNTYPED) {
            return;
        }
        if (Unify.isComplete(object)) {
            TypeConstrainer.check(clazz, object);
        } else {
            new TypeConstrainer(clazz, object, stateRecorder);
        }
    }

    private static void check(Class<?> clazz, Object object) throws Impossible {
        if (object instanceof Calculator) {
            Class<?> clazz2 = ((Calculator)object).getType();
            if (clazz != clazz2 && (clazz.isPrimitive() || !Types.allowsReferenceWidening(clazz2, clazz))) {
                try {
                    String string = "Type mismatch: Primitive " + String.valueOf(clazz) + ", calculation result: " + String.valueOf(clazz2);
                    logger.debug((Object)string);
                    throw new Impossible(string);
                }
                catch (RuntimeException runtimeException) {
                    String string = "Type mismatch (diagnostics not available).";
                    logger.debug((Object)string, (Throwable)runtimeException);
                    throw new Impossible(string, runtimeException);
                }
            }
        } else if (object instanceof Value) {
            if (!clazz.isPrimitive() || !Types.objectify(clazz).isInstance(((Value)object).value)) {
                try {
                    String string = "Type mismatch: Class " + String.valueOf(clazz) + ", primitive value: " + String.valueOf(object);
                    logger.debug((Object)string);
                    throw new Impossible(string);
                }
                catch (RuntimeException runtimeException) {
                    String string = "Type mismatch (diagnostics not available).";
                    logger.debug((Object)string, (Throwable)runtimeException);
                    throw new Impossible(string, runtimeException);
                }
            }
        } else if (object == null) {
            if (clazz.isPrimitive()) {
                try {
                    String string = "Type mismatch: Primitive " + String.valueOf(clazz) + ", null reference";
                    logger.debug((Object)string);
                    throw new Impossible(string);
                }
                catch (RuntimeException runtimeException) {
                    String string = "Type mismatch (diagnostics not available).";
                    logger.debug((Object)string, (Throwable)runtimeException);
                    throw new Impossible(string, runtimeException);
                }
            }
        } else if (!clazz.isInstance(object)) {
            try {
                String string = "Type mismatch: Class " + String.valueOf(clazz) + ", object: " + String.valueOf(object);
                logger.debug((Object)string);
                throw new Impossible(string);
            }
            catch (RuntimeException runtimeException) {
                String string = "Type mismatch (diagnostics not available).";
                logger.debug((Object)string, (Throwable)runtimeException);
                throw new Impossible(string, runtimeException);
            }
        }
    }

    @Override
    public void possiblyCompleted(Set<Notifiable> set, StateRecorder stateRecorder) throws Impossible {
        TypeConstrainer.check(this.type, this.reference.value);
    }
}

