/*
 * Decompiled with CFR 0.152.
 */
package de.renew.shadow;

import de.renew.net.loading.Finder;
import de.renew.shadow.ShadowNet;
import de.renew.shadow.ShadowNetSystem;
import de.renew.util.ClassSource;
import de.renew.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class SNSFinder
extends Finder {
    public static Logger logger = Logger.getLogger(SNSFinder.class);
    private final String[] shadowExtensions = new String[]{".sns", ".sha"};

    @Override
    public ShadowNetSystem findNetFile(String string, String string2) {
        boolean bl = true;
        URL uRL = null;
        for (int i = 0; bl && i < this.shadowExtensions.length; ++i) {
            Serializable serializable;
            bl = false;
            String string3 = string2 + this.shadowExtensions[i];
            logger.debug((Object)("SNSFinder: looking for: " + string3));
            try {
                serializable = new File(string3);
                if (serializable.canRead()) {
                    uRL = serializable.toURI().toURL();
                } else {
                    bl = true;
                }
            }
            catch (Exception exception) {
                logger.error((Object)("SNSFinder: " + string3 + " caused " + String.valueOf(exception)));
                logger.debug((Object)exception.getMessage(), (Throwable)exception);
                bl = true;
            }
            if (bl) continue;
            try {
                serializable = this.loadNetSystemFromURL(uRL, string);
                if (serializable == null) continue;
                return serializable;
            }
            catch (Exception exception) {
                logger.error((Object)("SNSFinder: " + String.valueOf(uRL) + " caused " + String.valueOf(exception)));
                logger.debug((Object)exception.getMessage(), (Throwable)exception);
                bl = true;
            }
        }
        return null;
    }

    @Override
    public ShadowNetSystem findNetClasspathRel(String string, String string2) {
        boolean bl = true;
        for (int i = 0; bl && i < this.shadowExtensions.length; ++i) {
            bl = false;
            String string3 = string2 + this.shadowExtensions[i];
            logger.debug((Object)("SNSFinder: looking for: " + string3));
            URL uRL = ClassSource.getClassLoader().getResource(StringUtil.convertToSlashes((String)string3));
            boolean bl2 = bl = uRL == null;
            if (bl) continue;
            try {
                ShadowNetSystem shadowNetSystem = this.loadNetSystemFromURL(uRL, string);
                if (shadowNetSystem == null) continue;
                return shadowNetSystem;
            }
            catch (Exception exception) {
                logger.error((Object)("SNSFinder: " + String.valueOf(uRL) + " caused " + String.valueOf(exception)));
                logger.debug((Object)exception.getMessage(), (Throwable)exception);
                bl = true;
            }
        }
        return null;
    }

    private ShadowNetSystem loadNetSystemFromURL(URL uRL, String string) throws IOException, ClassNotFoundException {
        logger.debug((Object)("Loading shadow net from " + String.valueOf(uRL)));
        InputStream inputStream = uRL.openStream();
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        ShadowNetSystem shadowNetSystem = (ShadowNetSystem)objectInputStream.readObject();
        objectInputStream.close();
        Iterator<ShadowNet> iterator = shadowNetSystem.elements().iterator();
        if (iterator.hasNext()) {
            ShadowNet shadowNet = iterator.next();
            if (iterator.hasNext()) {
                logger.error((Object)("SNSFinder: " + String.valueOf(uRL) + " contains more than one shadow net. Ignored."));
            } else if (shadowNet.getName().equals(string)) {
                logger.debug((Object)("SNSFinder: found net " + string + " at " + String.valueOf(uRL)));
                return shadowNetSystem;
            }
        }
        logger.warn((Object)("SNSFinder: " + String.valueOf(uRL) + " was empty!? Ignored."));
        return null;
    }
}

