/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net;

import de.renew.database.Transaction;
import de.renew.database.TransactionSource;
import de.renew.engine.searchqueue.SearchQueue;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.net.NetInstance;
import de.renew.net.Place;
import de.renew.net.SimulatablePlaceInstance;
import de.renew.net.TestTokenBag;
import de.renew.net.TimeSet;
import de.renew.net.TokenBag;
import de.renew.net.event.TokenEvent;
import de.renew.unify.Impossible;
import de.renew.unify.TupleIndex;
import de.renew.util.DelayedFieldOwner;
import de.renew.util.RenewObjectInputStream;
import de.renew.util.RenewObjectOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class MultisetPlaceInstance
extends SimulatablePlaceInstance {
    public static Logger logger = Logger.getLogger(MultisetPlaceInstance.class);
    static final long serialVersionUID = 0L;
    private int freeTokenCount;
    private int testedTokenCount;
    private transient TokenBag freeTokens;
    private transient TestTokenBag testedTokens;
    private transient TupleIndex freeIndex;
    private transient TupleIndex testIndex;

    MultisetPlaceInstance(NetInstance netInstance, Place place, boolean bl) throws Impossible {
        super(netInstance, place, bl);
    }

    @Override
    protected void initTokenStorage() {
        this.freeTokens = new TokenBag();
        this.testedTokens = new TestTokenBag();
        this.freeTokenCount = 0;
        this.testedTokenCount = 0;
        this.freeIndex = new TupleIndex();
        this.testIndex = new TupleIndex();
    }

    @Override
    public Set<Object> getDistinctTokens() {
        return this.freeIndex.getAllElements();
    }

    @Override
    public Set<Object> getDistinctTokens(Object object) {
        return this.freeIndex.getPossibleMatches(object);
    }

    @Override
    public Set<Object> getDistinctTestableTokens() {
        return this.testIndex.getAllElements();
    }

    @Override
    public Set<Object> getDistinctTestableTokens(Object object) {
        return this.testIndex.getPossibleMatches(object);
    }

    @Override
    public int getNumberOfTokens() {
        return this.freeTokenCount;
    }

    @Override
    public int getNumberOfTestedTokens() {
        return this.testedTokenCount;
    }

    @Override
    boolean containsToken(Object object) {
        return this.freeTokens.includesAnytime(object);
    }

    @Override
    public int getTokenCount(Object object) {
        return this.freeTokens.getMultiplicity(object);
    }

    @Override
    public TimeSet getFreeTimeSet(Object object) {
        return this.freeTokens.getTimeSet(object);
    }

    @Override
    public double computeEarliestTime(Object object, TimeSet timeSet) {
        return this.freeTokens.computeEarliestTime(object, timeSet);
    }

    @Override
    public boolean containsTestedToken(Object object) {
        return this.testedTokens.includesTested(object);
    }

    @Override
    public boolean containsTestableToken(Object object) {
        return this.containsToken(object) || this.containsTestedToken(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double removeToken(Object object, double d) throws Impossible {
        double d2;
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.lock.lock();
        try {
            d2 = 0.0;
            try {
                d2 = this.freeTokens.removeWithDelay(object, d);
            }
            catch (Exception exception) {
                throw new Impossible(exception);
            }
            --this.freeTokenCount;
            if (!this.freeTokens.includesAnytime(object)) {
                this.freeIndex.remove(object);
                if (!this.testedTokens.includesTested(object)) {
                    this.testIndex.remove(object);
                }
            }
            Transaction transaction = TransactionSource.get();
            try {
                transaction.removeToken(this, object, d2);
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
            this.triggerables.proposeSearch();
            TokenEvent tokenEvent = new TokenEvent(this, object);
            this.listeners.tokenRemoved(tokenEvent);
            this.place.getListenerSet().tokenRemoved(tokenEvent);
            this.unreserve(object);
        }
        finally {
            this.lock.unlock();
        }
        return d2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double testToken(Object object) throws Impossible {
        double d;
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.lock.lock();
        try {
            boolean bl = false;
            d = SearchQueue.getTime();
            if (!this.testedTokens.includesTested(object)) {
                try {
                    d = this.freeTokens.removeWithDelay(object, 0.0);
                }
                catch (Exception exception) {
                    throw new Impossible(exception);
                }
                ++this.testedTokenCount;
                --this.freeTokenCount;
                if (!this.freeTokens.includesAnytime(object)) {
                    this.freeIndex.remove(object);
                }
                bl = true;
            }
            this.testedTokens.addTested(object, d);
            if (bl) {
                this.triggerables.proposeSearch();
                TokenEvent tokenEvent = new TokenEvent(this, object);
                this.listeners.tokenTested(tokenEvent);
                this.place.getListenerSet().tokenTested(tokenEvent);
            }
        }
        finally {
            this.lock.unlock();
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void extractAllTokens(Vector<Object> vector, Vector<Double> vector2) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.lock.lock();
        try {
            ArrayList<Object> arrayList = new ArrayList<Object>(this.getDistinctTokens());
            while (!arrayList.isEmpty()) {
                Object e = arrayList.remove(arrayList.size() - 1);
                while (this.containsToken(e)) {
                    double d = 0.0;
                    try {
                        d = this.removeToken(e, Double.NEGATIVE_INFINITY);
                    }
                    catch (Impossible impossible) {
                        throw new RuntimeException("Token was not removable.", impossible);
                    }
                    if (vector != null) {
                        vector.addElement(e);
                    }
                    if (vector2 == null) continue;
                    vector2.addElement(new Double(d));
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void internallyInsertToken(Object object, double d, boolean bl) {
        this.internallyInsertTokenMultiple(object, d, 1, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internallyInsertTokenMultiple(Object object, double d, int n, boolean bl) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        assert (n > 0) : "trying to insert non-positive number of tokens";
        this.lock.lock();
        try {
            if (!this.freeTokens.includesAnytime(object)) {
                this.freeIndex.insert(object);
                if (!this.testedTokens.includesTested(object)) {
                    this.testIndex.insert(object);
                }
            }
            this.freeTokens.add(object, d, n);
            this.freeTokenCount += n;
            if (!bl) {
                this.reserve(object, n);
            }
            this.triggerables.proposeSearch();
            TokenEvent tokenEvent = new TokenEvent(this, object);
            this.listeners.tokenAdded(tokenEvent);
            this.place.getListenerSet().tokenAdded(tokenEvent);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void untestToken(Object object) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.lock.lock();
        try {
            double d = this.testedTokens.removeTested(object);
            if (!this.testedTokens.includesTested(object)) {
                if (!this.freeTokens.includesAnytime(object)) {
                    this.freeIndex.insert(object);
                }
                this.freeTokens.add(object, d);
                ++this.freeTokenCount;
                --this.testedTokenCount;
                this.triggerables.proposeSearch();
                TokenEvent tokenEvent = new TokenEvent(this, object);
                this.listeners.tokenUntested(tokenEvent);
                this.place.getListenerSet().tokenUntested(tokenEvent);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        RenewObjectOutputStream renewObjectOutputStream = null;
        if (objectOutputStream instanceof RenewObjectOutputStream) {
            renewObjectOutputStream = (RenewObjectOutputStream)objectOutputStream;
        }
        if (renewObjectOutputStream != null) {
            renewObjectOutputStream.beginDomain((Object)this);
        }
        objectOutputStream.defaultWriteObject();
        if (renewObjectOutputStream != null) {
            renewObjectOutputStream.delayedWriteObject((Object)this.freeTokens, (DelayedFieldOwner)this);
            renewObjectOutputStream.delayedWriteObject((Object)this.testedTokens, (DelayedFieldOwner)this);
            renewObjectOutputStream.endDomain((Object)this);
        } else {
            objectOutputStream.writeObject(this.freeTokens);
            objectOutputStream.writeObject(this.testedTokens);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        objectInputStream.defaultReadObject();
        if (!(objectInputStream instanceof RenewObjectInputStream)) {
            this.freeTokens = (TokenBag)objectInputStream.readObject();
            this.testedTokens = (TestTokenBag)objectInputStream.readObject();
            this.recomputeIndexes();
        }
    }

    @Override
    public void reassignField(Object object) throws IOException {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        if (!this.tryReassignField(object)) {
            if (object instanceof TokenBag) {
                this.freeTokens = (TokenBag)object;
            } else if (object instanceof TestTokenBag) {
                this.testedTokens = (TestTokenBag)object;
                this.recomputeIndexes();
            } else {
                throw new NotSerializableException("Value of unexpected type given to MultiSetPlaceInstance.reassignField():" + object.getClass().getName() + ".");
            }
        }
    }

    private void recomputeIndexes() {
        this.freeIndex = new TupleIndex();
        this.addToIndex(this.freeIndex, this.freeTokens.uniqueElements());
        this.testIndex = new TupleIndex();
        this.addToIndex(this.testIndex, this.freeTokens.uniqueElements());
        this.addToIndex(this.testIndex, this.testedTokens.uniqueElements());
    }

    private void addToIndex(TupleIndex tupleIndex, Collection<Object> collection) {
        for (Object object : collection) {
            tupleIndex.insert(object);
        }
    }

    protected void finalize() throws Throwable {
        for (Object object : this.testIndex.getAllElements()) {
            this.unreserve(object);
        }
        super.finalize();
    }
}

