/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.simulator;

import de.renew.database.TransactionSource;
import de.renew.engine.common.StepIdentifier;
import de.renew.engine.searcher.Finder;
import de.renew.engine.searcher.Searchable;
import de.renew.engine.searcher.Searcher;
import de.renew.engine.searcher.Triggerable;
import de.renew.engine.searchqueue.SearchQueue;
import de.renew.engine.searchqueue.SearchQueueListener;
import de.renew.engine.simulator.AbortFinder;
import de.renew.engine.simulator.ExecuteFinder;
import de.renew.engine.simulator.OverallEarliestTimeFinder;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.engine.simulator.Simulator;
import de.renew.engine.simulator.SimulatorEventQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public class AbstractConcurrentSimulator
implements Runnable,
Simulator,
SearchQueueListener {
    public static Logger logger = Logger.getLogger(AbstractConcurrentSimulator.class);
    private static long runCounter = 0L;
    protected long simulationRunId;
    private Searcher searcher = new Searcher();
    private static final Lock lock = new ReentrantLock();
    private boolean wantConcurrentExecution;
    private boolean wantEventQueueDelay;
    private ExecuteFinder executeFinder;
    private AbortFinder abortFinder;
    private long cycle = 0L;
    private static int SIMULATION_TERMINATE = -1;
    private static int SIMULATION_STOP = 0;
    private static int SIMULATION_STEP = 1;
    private static int SIMULATION_RUN = 2;
    private int desiredMode = SIMULATION_STOP;
    private boolean idle = true;
    private int stepStatusCode = 0;
    private boolean searchQueueIsEmpty = false;
    private boolean alreadyRegistered = false;
    private Object threadLock = new Object();

    public AbstractConcurrentSimulator(boolean bl, boolean bl2) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.wantEventQueueDelay = bl;
        this.wantConcurrentExecution = bl2;
        this.simulationRunId = ((long)this.getClass().getName().hashCode() << 32) + runCounter++;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.getClass().getSimpleName() + ": Starting run with id " + this.simulationRunId));
        }
        this.setupFinders();
        SimulationThreadPool.getCurrent().execute(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupFinders() {
        Object object = this.threadLock;
        synchronized (object) {
            this.executeFinder = new ExecuteFinder();
            this.abortFinder = new AbortFinder(this.executeFinder);
        }
    }

    @Override
    public boolean isActive() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void searchQueueNonempty() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        Object object = this.threadLock;
        synchronized (object) {
            this.searchQueueIsEmpty = false;
            this.alreadyRegistered = false;
            this.threadLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerAtSearchQueue() {
        Class<SearchQueue> clazz = SearchQueue.class;
        synchronized (SearchQueue.class) {
            Object object = this.threadLock;
            synchronized (object) {
                this.searchQueueIsEmpty = SearchQueue.isTotallyEmpty();
                if (this.searchQueueIsEmpty && !this.alreadyRegistered) {
                    SearchQueue.insertListener(this);
                    this.alreadyRegistered = true;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void terminateRun() {
        SimulationThreadPool.getCurrent().executeAndWait(new Runnable(){

            @Override
            public void run() {
                AbstractConcurrentSimulator.this.requestMode(SIMULATION_TERMINATE);
                try {
                    TransactionSource.simulationStateChanged(false, false);
                }
                catch (Exception exception) {
                    logger.error((Object)exception.getMessage(), (Throwable)exception);
                }
            }
        });
    }

    @Override
    public void stopRun() {
        SimulationThreadPool.getCurrent().executeAndWait(new Runnable(){

            @Override
            public void run() {
                AbstractConcurrentSimulator.this.requestMode(SIMULATION_STOP);
                try {
                    TransactionSource.simulationStateChanged(true, false);
                }
                catch (Exception exception) {
                    logger.error((Object)exception.getMessage(), (Throwable)exception);
                }
            }
        });
    }

    @Override
    public int step() {
        Future<Integer> future = SimulationThreadPool.getCurrent().submitAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                lock.lock();
                AbstractConcurrentSimulator.this.requestMode(SIMULATION_STEP);
                try {
                    TransactionSource.simulationStateChanged(true, false);
                }
                catch (Exception exception) {
                    logger.error((Object)exception.getMessage(), (Throwable)exception);
                }
                lock.unlock();
                return AbstractConcurrentSimulator.this.stepStatusCode;
            }
        });
        try {
            return future.get();
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            logger.error((Object)"Simulation thread threw an exception", (Throwable)executionException);
        }
        return -1;
    }

    @Override
    public void startRun() {
        SimulationThreadPool.getCurrent().execute(new Runnable(){

            @Override
            public void run() {
                AbstractConcurrentSimulator.this.requestMode(SIMULATION_RUN);
                try {
                    TransactionSource.simulationStateChanged(true, true);
                }
                catch (Exception exception) {
                    logger.error((Object)exception.getMessage(), (Throwable)exception);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestMode(int n) {
        Object object = this.threadLock;
        synchronized (object) {
            if (this.desiredMode > SIMULATION_TERMINATE) {
                this.desiredMode = n;
                if (n > SIMULATION_STOP) {
                    this.idle = false;
                } else {
                    this.abortFinder.abortSearch();
                }
                this.threadLock.notifyAll();
            }
            if (n < SIMULATION_RUN && this.desiredMode < SIMULATION_RUN) {
                while (!this.idle) {
                    try {
                        this.threadLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object;
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        while (this.desiredMode >= SIMULATION_STOP) {
            Object object2;
            object = this.threadLock;
            synchronized (object) {
                while (this.searchQueueIsEmpty && this.desiredMode == SIMULATION_RUN) {
                    try {
                        this.threadLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.stepStatusCode = 0;
            object = null;
            while (this.desiredMode > SIMULATION_STOP && (object = SearchQueue.extract()) != null) {
                this.setupFinders();
                if (this.desiredMode <= SIMULATION_STOP) continue;
                object2 = new OverallEarliestTimeFinder(this.abortFinder);
                this.searcher.searchAndRecover((Finder)object2, (Searchable)object, (Triggerable)object);
                Thread.yield();
                if (this.abortFinder.isCompleted()) {
                    SearchQueue.includeNow((Searchable)object);
                } else {
                    ((OverallEarliestTimeFinder)object2).insertIntoSearchQueue((Searchable)object);
                }
                if (!this.executeFinder.isCompleted()) continue;
                if (this.wantEventQueueDelay) {
                    SimulatorEventQueue.awaitEmptyQueue();
                }
                this.executeFinder.execute(this.nextStepIdentifier(), this.wantConcurrentExecution);
                this.setupFinders();
                this.stepStatusCode = 1;
                Object object3 = this.threadLock;
                synchronized (object3) {
                    if (this.desiredMode == SIMULATION_STEP) {
                        this.desiredMode = SIMULATION_STOP;
                    }
                }
            }
            if (object != null) {
                SearchQueue.includeNow((Searchable)object);
                object = null;
            }
            this.registerAtSearchQueue();
            object2 = this.threadLock;
            synchronized (object2) {
                if (this.desiredMode == SIMULATION_STEP) {
                    this.desiredMode = SIMULATION_STOP;
                    this.stepStatusCode = 3;
                }
                if (this.desiredMode <= SIMULATION_STOP) {
                    this.idle = true;
                    this.threadLock.notifyAll();
                }
                while (this.desiredMode == SIMULATION_STOP) {
                    try {
                        this.threadLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        object = this.threadLock;
        synchronized (object) {
            if (!this.idle) {
                this.idle = true;
                this.threadLock.notifyAll();
            }
        }
    }

    @Override
    public void refresh() {
    }

    @Override
    public boolean isSequential() {
        return !this.wantConcurrentExecution;
    }

    @Override
    public StepIdentifier nextStepIdentifier() {
        Future<StepIdentifier> future = SimulationThreadPool.getCurrent().submitAndWait(new Callable<StepIdentifier>(){

            @Override
            public StepIdentifier call() throws Exception {
                return new StepIdentifier(AbstractConcurrentSimulator.this.simulationRunId, new long[]{++AbstractConcurrentSimulator.this.cycle});
            }
        });
        try {
            return future.get();
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            logger.error((Object)"Simulation thread threw an exception", (Throwable)executionException);
        }
        return null;
    }

    @Override
    public StepIdentifier currentStepIdentifier() {
        Future<StepIdentifier> future = SimulationThreadPool.getCurrent().submitAndWait(new Callable<StepIdentifier>(){

            @Override
            public StepIdentifier call() throws Exception {
                return new StepIdentifier(AbstractConcurrentSimulator.this.simulationRunId, new long[]{AbstractConcurrentSimulator.this.cycle});
            }
        });
        try {
            return future.get();
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            logger.error((Object)"Simulation thread threw an exception", (Throwable)executionException);
        }
        return null;
    }

    @Override
    public long[] collectSimulationRunIds() {
        return new long[]{this.simulationRunId};
    }
}

