/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.common;

import de.renew.engine.common.SimulatorEvent;
import de.renew.engine.common.StepIdentifier;
import de.renew.engine.events.SimulationEvent;
import de.renew.engine.events.TraceEvent;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.net.NetInstance;
import de.renew.net.PlaceInstance;
import de.renew.net.TransitionInstance;
import org.apache.log4j.Logger;

public class SimulatorEventLogger {
    public static final String SIM_LOG_PREFIX = "simulation";

    public static void log(SimulatorEvent simulatorEvent) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        SimulatorEventLogger.getLogger(simulatorEvent).debug((Object)simulatorEvent);
    }

    public static void log(SimulationEvent simulationEvent) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        try {
            SimulatorEventLogger.log(new SimulatorEvent(simulationEvent));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void log(StepIdentifier stepIdentifier, SimulationEvent simulationEvent) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        SimulatorEventLogger.log(new SimulatorEvent(stepIdentifier, simulationEvent));
    }

    public static void log(StepIdentifier stepIdentifier, SimulationEvent simulationEvent, PlaceInstance placeInstance) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        SimulatorEventLogger.log(new SimulatorEvent(stepIdentifier, simulationEvent, placeInstance));
    }

    public static void log(StepIdentifier stepIdentifier, SimulationEvent simulationEvent, TransitionInstance transitionInstance) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        SimulatorEventLogger.log(new SimulatorEvent(stepIdentifier, simulationEvent, transitionInstance));
    }

    public static void log(StepIdentifier stepIdentifier, SimulationEvent simulationEvent, NetInstance netInstance) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        SimulatorEventLogger.log(new SimulatorEvent(stepIdentifier, simulationEvent, netInstance));
    }

    public static void log(String string) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        try {
            SimulatorEventLogger.log(new SimulatorEvent(new TraceEvent(string)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void log(StepIdentifier stepIdentifier, String string) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        SimulatorEventLogger.log(new SimulatorEvent(stepIdentifier, new TraceEvent(string)));
    }

    public static void log(StepIdentifier stepIdentifier, String string, PlaceInstance placeInstance) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        SimulatorEventLogger.log(new SimulatorEvent(stepIdentifier, (SimulationEvent)new TraceEvent(string), placeInstance));
    }

    public static void log(StepIdentifier stepIdentifier, String string, TransitionInstance transitionInstance) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        SimulatorEventLogger.log(new SimulatorEvent(stepIdentifier, (SimulationEvent)new TraceEvent(string), transitionInstance));
    }

    public static void log(StepIdentifier stepIdentifier, String string, NetInstance netInstance) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        SimulatorEventLogger.log(new SimulatorEvent(stepIdentifier, (SimulationEvent)new TraceEvent(string), netInstance));
    }

    private static Logger getLogger(SimulatorEvent simulatorEvent) {
        StringBuffer stringBuffer = new StringBuffer(SIM_LOG_PREFIX);
        if (simulatorEvent.getNetInstance() != null) {
            stringBuffer.append(".");
            stringBuffer.append(simulatorEvent.getNetInstance().getNet().getName());
            if (simulatorEvent.getNetElementInstance() != null) {
                Object object = simulatorEvent.getNetElementInstance();
                if (object instanceof TransitionInstance) {
                    stringBuffer.append(".");
                    stringBuffer.append(((TransitionInstance)object).getTransition().toString());
                } else if (object instanceof PlaceInstance) {
                    stringBuffer.append(".");
                    stringBuffer.append(((PlaceInstance)object).getPlace().toString());
                }
            }
        }
        return Logger.getLogger((String)stringBuffer.toString());
    }
}

