/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.simulator;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.framework.Drawing;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.engine.simulator.XMLOmitDeclStreamWriter;
import de.renew.formalism.ccpn.CCPNPlugin;
import de.renew.gui.CPNDrawing;
import de.renew.gui.pnml.creator.PNMLCreator;
import de.renew.io.exportFormats.PNMLExportFormat;
import de.renew.net.CurryPlaceInstance;
import de.renew.net.NetElementID;
import de.renew.net.NetInstance;
import de.renew.net.Place;
import de.renew.rnrg.elements.CurryNode;
import de.renew.rnrg.elements.Node;
import de.renew.rnrg.gui.GraphDrawing;
import de.renew.unify.Impossible;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stax.StAXResult;
import org.apache.log4j.Logger;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CCPNProcess {
    public static Logger logger = Logger.getLogger(CCPNProcess.class);
    private final Process process;
    private final List<Place> places;
    private final NetInstance simNetInstance;
    boolean continuousUpdate = false;
    boolean stopped = false;
    final XMLStreamWriter writer;

    public static CCPNProcess startProcess(NetInstance netInstance, CPNDrawing cPNDrawing) {
        Document document;
        Object object2;
        List list;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(CCPNProcess.class.getSimpleName() + ": starting process..."));
        }
        PNMLCreator pNMLCreator = new PNMLCreator(PNMLExportFormat.ptNetType, true);
        try {
            list = pNMLCreator.setDrawings(cPNDrawing);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException(parserConfigurationException);
        }
        ArrayList<Place> arrayList = new ArrayList<Place>(list.size());
        for (Object object2 : list) {
            arrayList.add(netInstance.getNet().getPlaceWithID(new NetElementID(object2.getID())));
        }
        ProcessBuilder processBuilder = new ProcessBuilder(CCPNPlugin.getCCPNLocation());
        try {
            object2 = new CCPNProcess(processBuilder.start(), arrayList, netInstance);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException(iOException);
        }
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException(parserConfigurationException);
        }
        Element element = document.createElement("load");
        File file = cPNDrawing.getFilename();
        if (file != null) {
            try {
                element.setAttribute("baseFile", file.getCanonicalPath());
            }
            catch (DOMException dOMException) {
                dOMException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        element.appendChild(document.adoptNode(pNMLCreator.getDocumentElement()));
        ((CCPNProcess)object2).sendElement(element);
        ((CCPNProcess)object2).execute();
        return object2;
    }

    private void execute() {
        SimulationThreadPool.getCurrent().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    SAXParserFactory.newInstance().newSAXParser().parse((InputStream)new BufferedInputStream(CCPNProcess.this.process.getInputStream()), (DefaultHandler)new SAXHandler());
                }
                catch (SAXException sAXException) {
                    sAXException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    parserConfigurationException.printStackTrace();
                }
            }
        });
    }

    public CCPNProcess(Process process, List<Place> list, NetInstance netInstance) {
        this.process = process;
        this.places = list;
        this.simNetInstance = netInstance;
        try {
            this.writer = XMLOutputFactory.newFactory().createXMLStreamWriter(new BufferedOutputStream(process.getOutputStream()), "UTF-8");
            this.writer.writeStartDocument();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new RuntimeException(xMLStreamException);
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new RuntimeException(factoryConfigurationError);
        }
    }

    public void terminate() {
        this.stopped = true;
        this.continuousUpdate = false;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(CCPNProcess.class.getSimpleName() + ": closing XML stream to process."));
        }
        try {
            this.writer.writeEndDocument();
            this.writer.flush();
            this.writer.close();
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
        try {
            this.process.getOutputStream().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void run() {
        this.sendElement("run");
        this.getMarking();
    }

    void stop() {
        this.sendElement("stop");
        this.getMarking();
    }

    void step() {
        this.sendElement("step");
        this.getMarking();
    }

    void reachGraph() {
        this.sendElement("reachGraph");
    }

    private void getMarking() {
        this.sendElement("getMarking");
    }

    private void sendElement(Element element) {
        if (this.stopped) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(CCPNProcess.class.getSimpleName() + ": sending " + element.getTagName() + " DOM element"));
        }
        try {
            TransformerFactory.newInstance().newTransformer().transform(new DOMSource(element), new StAXResult(new XMLOmitDeclStreamWriter(this.writer)));
            this.writer.writeEndDocument();
            this.writer.flush();
        }
        catch (TransformerException transformerException) {
            throw new RuntimeException(transformerException);
        }
        catch (XMLStreamException xMLStreamException) {
            CCPNProcess.handleXMLStreamException(xMLStreamException);
        }
    }

    private void sendElement(String string) {
        if (this.stopped) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(CCPNProcess.class.getSimpleName() + ": sending " + string + " empty element"));
        }
        try {
            this.writer.writeEmptyElement(string);
            this.writer.writeEndDocument();
            this.writer.flush();
        }
        catch (XMLStreamException xMLStreamException) {
            CCPNProcess.handleXMLStreamException(xMLStreamException);
        }
    }

    private static void handleXMLStreamException(XMLStreamException xMLStreamException) {
        Throwable throwable = xMLStreamException.getCause();
        if (throwable instanceof IOException && "Stream closed".equals(throwable.getMessage())) {
            return;
        }
        throw new RuntimeException(xMLStreamException);
    }

    private class SAXHandler
    extends DefaultHandler {
        private static final String CCPN_OUTPUT = "ccpnOutput";
        private static final String NET_MARKING = "netMarking";
        private static final String NET_MARKING_STOPPED = "stopped";
        private static final String NET_MARKING_STOPPED_TRUE = "true";
        private static final String PLACE_STATE = "placeState";
        private static final String TOKEN = "token";
        private static final String TOKEN_COUNT = "count";
        private static final String ERROR = "error";
        private static final String LOAD_ERROR = "loadError";
        private static final String LOAD_WARNING = "loadWarning";
        private static final String REACH_GRAPH = "reachGraph";
        private static final String INITIAL_STATE = "initialState";
        private static final String ID = "id";
        private static final String REF = "ref";
        private static final String NAME = "name";
        private static final String TARGET = "target";
        private static final String NODE = "node";
        private static final String EDGE = "edge";
        private StringBuffer errorStringBuffer = null;
        private StringBuffer loadErrorStringBuffer = null;
        private StringBuffer loadWarningStringBuffer = null;
        private Stack<StringBuffer> debugOutput;
        private Iterator<Place> placeIterator;
        private CurryPlaceInstance currentPlace;
        private StringBuffer currentTokenStr = null;
        private int currentTokenCount;
        private CurryNode startNode = null;
        private List<String> initialStates = null;
        private Map<String, NodeEntry> nodes = null;
        private NodeEntry currentNode = null;
        private EdgeEntry currentEdge;

        private SAXHandler() {
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(CCPNProcess.class.getSimpleName() + ": CCPN " + (CCPNProcess.this.stopped ? "(stopped) " : "") + "returned: <" + string3 + ">"));
            }
            if (TOKEN.equalsIgnoreCase(string3)) {
                this.currentTokenStr = new StringBuffer();
                this.currentTokenCount = Integer.parseUnsignedInt(attributes.getValue("", TOKEN_COUNT));
            } else if (PLACE_STATE.equalsIgnoreCase(string3)) {
                NetInstance netInstance = this.currentNode == null ? CCPNProcess.this.simNetInstance : this.currentNode.node.getRootNetInstance();
                this.currentPlace = (CurryPlaceInstance)netInstance.getInstance(this.placeIterator.next());
                this.currentPlace.resetMarking();
            } else if (NET_MARKING.equalsIgnoreCase(string3)) {
                this.placeIterator = CCPNProcess.this.places.iterator();
                if (NET_MARKING_STOPPED_TRUE.equalsIgnoreCase(attributes.getValue("", NET_MARKING_STOPPED))) {
                    CCPNProcess.this.continuousUpdate = false;
                }
            } else if (ERROR.equalsIgnoreCase(string3)) {
                this.errorStringBuffer = new StringBuffer();
            } else if (LOAD_ERROR.equalsIgnoreCase(string3)) {
                this.loadErrorStringBuffer = new StringBuffer();
            } else if (LOAD_WARNING.equalsIgnoreCase(string3)) {
                this.loadWarningStringBuffer = new StringBuffer();
            } else if (EDGE.equalsIgnoreCase(string3)) {
                this.currentEdge = new EdgeEntry(attributes.getValue("", NAME), attributes.getValue("", TARGET));
            } else if (NODE.equalsIgnoreCase(string3)) {
                try {
                    this.currentNode = new NodeEntry(new CurryNode(CCPNProcess.this.simNetInstance.getNet().makeInstance()));
                }
                catch (Impossible impossible) {
                    impossible.printStackTrace();
                }
                this.nodes.put(attributes.getValue("", ID), this.currentNode);
            } else if (INITIAL_STATE.equalsIgnoreCase(string3)) {
                this.initialStates.add(attributes.getValue("", REF));
            } else if (REACH_GRAPH.equalsIgnoreCase(string3)) {
                try {
                    this.startNode = new CurryNode(CCPNProcess.this.simNetInstance.getNet().makeInstance());
                }
                catch (Impossible impossible) {
                    impossible.printStackTrace();
                }
                this.nodes = new HashMap<String, NodeEntry>();
                this.initialStates = new ArrayList<String>();
            } else if (logger.isDebugEnabled() && !CCPN_OUTPUT.equalsIgnoreCase(string3)) {
                if (this.debugOutput == null) {
                    this.debugOutput = new Stack();
                }
                this.debugOutput.push(new StringBuffer());
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) {
            if (TOKEN.equalsIgnoreCase(string3)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(CCPNProcess.class.getSimpleName() + ": " + this.currentTokenCount + " token" + (this.currentTokenCount > 1 ? "s" : "") + " in " + String.valueOf(this.currentPlace) + " : " + String.valueOf(this.currentTokenStr)));
                }
                this.currentPlace.addToken(this.currentTokenStr.toString(), this.currentTokenCount);
                this.currentTokenStr = null;
            } else if (PLACE_STATE.equalsIgnoreCase(string3)) {
                this.currentPlace.notifyListeners();
                this.currentPlace = null;
            } else if (NET_MARKING.equalsIgnoreCase(string3)) {
                this.placeIterator = null;
                if (CCPNProcess.this.continuousUpdate) {
                    CCPNProcess.this.getMarking();
                }
            } else if (ERROR.equalsIgnoreCase(string3)) {
                if (this.errorStringBuffer.length() == 0) {
                    logger.error((Object)"CCPN returned error.");
                } else {
                    logger.error((Object)("CCPN: " + this.errorStringBuffer.toString()));
                }
                this.errorStringBuffer = null;
            } else if (LOAD_ERROR.equalsIgnoreCase(string3)) {
                logger.error((Object)("CCPN errors while loading:\n" + this.loadErrorStringBuffer.toString()));
                this.loadErrorStringBuffer = null;
            } else if (LOAD_WARNING.equalsIgnoreCase(string3)) {
                logger.warn((Object)("CCPN warnings while loading\n:" + this.loadWarningStringBuffer.toString()));
                this.loadWarningStringBuffer = null;
            } else if (EDGE.equalsIgnoreCase(string3)) {
                this.currentNode.edges.add(this.currentEdge);
                this.currentEdge = null;
            } else if (NODE.equalsIgnoreCase(string3)) {
                this.currentNode = null;
            } else if (REACH_GRAPH.equalsIgnoreCase(string3)) {
                ArrayList<CurryNode> arrayList = new ArrayList<CurryNode>(this.nodes.size() + 1);
                for (String object : this.initialStates) {
                    this.startNode.addEdge(this.nodes.get((Object)object).node);
                }
                arrayList.add(this.startNode);
                for (NodeEntry nodeEntry : this.nodes.values()) {
                    for (EdgeEntry edgeEntry : nodeEntry.edges) {
                        nodeEntry.node.addEdge(edgeEntry.name, edgeEntry.description, this.nodes.get((Object)edgeEntry.target).node);
                    }
                    arrayList.add(nodeEntry.node);
                }
                DrawPlugin.getGui().openDrawing((Drawing)new GraphDrawing(arrayList, (Node)this.startNode, 0));
                this.startNode = null;
                this.nodes = null;
                this.initialStates = null;
            } else if (this.debugOutput != null && !this.debugOutput.empty()) {
                StringBuffer stringBuffer = this.debugOutput.pop();
                logger.debug((Object)(CCPNProcess.class.getSimpleName() + ": ignoring unknown element " + string3 + (String)(stringBuffer.length() == 0 ? "" : " with contents: " + stringBuffer.toString())));
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            if (this.currentTokenStr != null) {
                this.currentTokenStr.append(cArray, n, n2);
            } else if (this.errorStringBuffer != null) {
                this.errorStringBuffer.append(cArray, n, n2);
            } else if (this.loadErrorStringBuffer != null) {
                this.loadErrorStringBuffer.append(cArray, n, n2);
            } else if (this.loadWarningStringBuffer != null) {
                this.loadWarningStringBuffer.append(cArray, n, n2);
            } else if (this.currentEdge != null) {
                String string = String.valueOf(cArray, n, n2);
                this.currentEdge.description = this.currentEdge.description + string;
            } else if (this.debugOutput != null && !this.debugOutput.empty()) {
                this.debugOutput.peek().append(cArray, n, n2);
            }
        }

        @Override
        public void endDocument() {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(CCPNProcess.class.getSimpleName() + ": CCPN output ended."));
            }
        }

        final class NodeEntry {
            public final CurryNode node;
            public final List<EdgeEntry> edges = new ArrayList<EdgeEntry>();

            public NodeEntry(CurryNode curryNode) {
                this.node = curryNode;
            }
        }

        final class EdgeEntry {
            public final String name;
            public String description = "";
            public final String target;

            public EdgeEntry(String string, String string2) {
                this.name = string;
                this.target = string2;
            }
        }
    }
}

