/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.Locator;
import CH.ifa.draw.standard.LocatorHandle;
import CH.ifa.draw.util.Geom;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;

public class ConnectionHandle
extends LocatorHandle {
    private ConnectionFigure fConnection;
    private ConnectionFigure fPrototype;
    private Figure fTarget = null;

    public ConnectionHandle(Figure figure, Locator locator, ConnectionFigure connectionFigure) {
        super(figure, locator);
        this.fPrototype = connectionFigure;
    }

    @Override
    public void invokeStart(int n, int n2, DrawingView drawingView) {
        super.invokeStart(n, n2, drawingView);
        this.fConnection = this.createConnection();
        Point point = this.locate();
        this.fConnection.startPoint(point.x, point.y);
        this.fConnection.endPoint(point.x, point.y);
        drawingView.drawing().add(this.fConnection);
    }

    protected ConnectionFigure getConnection() {
        return this.fConnection;
    }

    @Override
    public void invokeStep(MouseEvent mouseEvent, int n, int n2, int n3, int n4, DrawingView drawingView) {
        Point point = new Point(n, n2);
        Figure figure = null;
        List<Figure> list = this.findAllConnectableFigures(n, n2, drawingView.drawing());
        Object object = list.iterator();
        while (object.hasNext()) {
            Figure figure2 = object.next();
            if (figure2 == null || !figure2.canConnect() || figure2.includes(this.owner()) || !this.fConnection.canConnect(this.owner(), figure2)) continue;
            figure = figure2;
            break;
        }
        if (figure != this.fTarget) {
            if (this.fTarget != null) {
                this.fTarget.connectorVisibility(false);
            }
            this.fTarget = figure;
            if (this.fTarget != null) {
                this.fTarget.connectorVisibility(true);
            }
        }
        if ((object = this.findConnectionTarget(point.x, point.y, drawingView.drawing())) != null) {
            point = Geom.center(object.displayBox());
        } else if (mouseEvent.isControlDown()) {
            point = this.snap(point.x, point.y);
        }
        this.fConnection.endPoint(point.x, point.y);
    }

    protected Point snap(int n, int n2) {
        return new Point(n, n2);
    }

    @Override
    public void invokeEnd(int n, int n2, int n3, int n4, DrawingView drawingView) {
        Connector connector = this.findConnectionTarget(n, n2, drawingView.drawing());
        if (connector != null) {
            this.fConnection.connectStart(this.startConnector());
            this.fConnection.connectEnd(connector);
            this.fConnection.updateConnection();
            drawingView.clearSelection();
            drawingView.addToSelection(connector.owner());
        } else {
            drawingView.drawing().remove(this.fConnection);
            this.noChangesMade();
        }
        this.fConnection = null;
        if (this.fTarget != null) {
            this.fTarget.connectorVisibility(false);
            this.fTarget = null;
        }
        super.invokeEnd(n, n2, n3, n4, drawingView);
    }

    private Connector startConnector() {
        Point point = this.locate();
        return this.owner().connectorAt(point.x, point.y);
    }

    protected ConnectionFigure createConnection() {
        return (ConnectionFigure)this.fPrototype.clone();
    }

    protected Connector findConnectionTarget(int n, int n2, Drawing drawing) {
        List<Figure> list = this.findAllConnectableFigures(n, n2, drawing);
        for (Figure figure : list) {
            if (figure == null || !figure.canConnect() || figure.includes(this.owner()) || !this.fConnection.canConnect(this.owner(), figure)) continue;
            return this.findConnector(n, n2, figure);
        }
        return null;
    }

    protected Figure findConnectableFigure(int n, int n2, Drawing drawing) {
        FigureEnumeration figureEnumeration = drawing.figuresReverse();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            if (figure.includes(this.fConnection) || !figure.canConnect() || !figure.containsPoint(n, n2)) continue;
            return figure;
        }
        return null;
    }

    protected List<Figure> findAllConnectableFigures(int n, int n2, Drawing drawing) {
        ArrayList<Figure> arrayList = new ArrayList<Figure>();
        FigureEnumeration figureEnumeration = drawing.figuresReverse();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            if (figure.includes(this.fConnection) || !figure.canConnect() || !figure.containsPoint(n, n2)) continue;
            arrayList.add(figure);
        }
        return arrayList;
    }

    protected Connector findConnector(int n, int n2, Figure figure) {
        return figure.connectorAt(n, n2);
    }

    @Override
    public void draw(Graphics graphics) {
        Rectangle rectangle = this.displayBox();
        graphics.setColor(Color.blue);
        graphics.drawOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }
}

