/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.UndoableCommand;
import java.awt.Rectangle;

public class AlignCommand
extends UndoableCommand {
    public static final int LEFTS = 0;
    public static final int CENTERS = 1;
    public static final int RIGHTS = 2;
    public static final int TOPS = 3;
    public static final int MIDDLES = 4;
    public static final int BOTTOMS = 5;
    public static final int ANCHOR_LAST = 0;
    public static final int ANCHOR_FIRST = 1;
    public static final int ANCHOR_BIGGEST = 2;
    public static final int ANCHOR_SMALLEST = 3;
    public static final int ANCHOR_SELECTION = 4;
    private int fOp;
    private int fAnchor;

    public AlignCommand(String string, int n) {
        this(string, n, 1);
    }

    public AlignCommand(String string, int n, int n2) {
        super(string);
        this.fOp = n;
        this.fAnchor = n2;
    }

    @Override
    public boolean isExecutable() {
        if (!super.isExecutable()) {
            return false;
        }
        return this.getEditor().view().selectionCount() > 1;
    }

    @Override
    public boolean executeUndoable() {
        if (this.isExecutable()) {
            if (!super.isExecutable()) {
                return false;
            }
            DrawingView drawingView = this.getEditor().view();
            Rectangle rectangle = this.getAnchor(drawingView, this.fAnchor, this.fOp);
            FigureEnumeration figureEnumeration = drawingView.selectionElements();
            while (figureEnumeration.hasMoreElements()) {
                Figure figure = figureEnumeration.nextFigure();
                Rectangle rectangle2 = figure.displayBox();
                switch (this.fOp) {
                    case 0: {
                        figure.moveBy(rectangle.x - rectangle2.x, 0);
                        break;
                    }
                    case 1: {
                        figure.moveBy(rectangle.x + rectangle.width / 2 - (rectangle2.x + rectangle2.width / 2), 0);
                        break;
                    }
                    case 2: {
                        figure.moveBy(rectangle.x + rectangle.width - (rectangle2.x + rectangle2.width), 0);
                        break;
                    }
                    case 3: {
                        figure.moveBy(0, rectangle.y - rectangle2.y);
                        break;
                    }
                    case 4: {
                        figure.moveBy(0, rectangle.y + rectangle.height / 2 - (rectangle2.y + rectangle2.height / 2));
                        break;
                    }
                    case 5: {
                        figure.moveBy(0, rectangle.y + rectangle.height - (rectangle2.y + rectangle2.height));
                    }
                }
            }
            drawingView.checkDamage();
            return true;
        }
        return false;
    }

    private Rectangle getAnchor(DrawingView drawingView, int n, int n2) {
        Rectangle rectangle = null;
        FigureEnumeration figureEnumeration = drawingView.selectionElements();
        if (figureEnumeration.hasMoreElements()) {
            Rectangle rectangle2;
            Rectangle rectangle3 = rectangle2 = figureEnumeration.nextFigure().displayBox();
            Rectangle rectangle4 = rectangle2;
            Rectangle rectangle5 = new Rectangle(rectangle2);
            Rectangle rectangle6 = rectangle2;
            while (figureEnumeration.hasMoreElements()) {
                Rectangle rectangle7 = figureEnumeration.nextFigure().displayBox();
                if (n2 == 0 || n2 == 1 || n2 == 2) {
                    if (rectangle7.width > rectangle3.width) {
                        rectangle3 = rectangle7;
                    }
                    if (rectangle7.width < rectangle4.width) {
                        rectangle4 = rectangle7;
                    }
                } else if (n2 == 3 || n2 == 4 || n2 == 5) {
                    if (rectangle7.height > rectangle3.height) {
                        rectangle3 = rectangle7;
                    }
                    if (rectangle7.height < rectangle4.height) {
                        rectangle4 = rectangle7;
                    }
                }
                rectangle5.add(rectangle7);
                if (figureEnumeration.hasMoreElements()) continue;
                rectangle6 = rectangle7;
            }
            switch (n) {
                case 2: {
                    rectangle = rectangle3;
                    break;
                }
                case 3: {
                    rectangle = rectangle4;
                    break;
                }
                case 1: {
                    rectangle = rectangle2;
                    break;
                }
                case 0: {
                    rectangle = rectangle6;
                    break;
                }
                case 4: {
                    rectangle = rectangle5;
                    break;
                }
                default: {
                    rectangle = rectangle2;
                }
            }
        }
        return rectangle;
    }
}

