/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.io;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.io.PositionedDrawing;
import CH.ifa.draw.io.SimpleFileFilter;
import CH.ifa.draw.io.StatusDisplayer;
import CH.ifa.draw.io.StorableInputDrawingLoader;
import CH.ifa.draw.io.importFormats.ImportFormat;
import CH.ifa.draw.util.StorableOutput;
import de.renew.util.StringUtil;
import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class DrawingFileHelper {
    public static Logger logger = Logger.getLogger(DrawingFileHelper.class);
    public static final int FILEVERSION = 11;
    private static StorableInputDrawingLoader loader = new StorableInputDrawingLoader();

    private DrawingFileHelper() {
    }

    private static Drawing toDrawing(PositionedDrawing positionedDrawing) {
        return positionedDrawing == null ? null : positionedDrawing.getDrawing();
    }

    private static List<Drawing> toDrawingList(List<PositionedDrawing> list) {
        ArrayList<Drawing> arrayList = new ArrayList<Drawing>(list.size());
        for (PositionedDrawing positionedDrawing : list) {
            arrayList.add(positionedDrawing.getDrawing());
        }
        return arrayList;
    }

    public static Drawing loadDrawing(File file, StatusDisplayer statusDisplayer) {
        return DrawingFileHelper.toDrawing(DrawingFileHelper.loadPositionedDrawing(file, statusDisplayer));
    }

    public static List<Drawing> loadDrawingList(File file, StatusDisplayer statusDisplayer) {
        return DrawingFileHelper.toDrawingList(DrawingFileHelper.loadPositionedDrawingList(file, statusDisplayer));
    }

    public static Drawing loadDrawing(InputStream inputStream, String string) throws FileNotFoundException, IOException {
        return DrawingFileHelper.toDrawing(DrawingFileHelper.loadPositionedDrawing(inputStream, string));
    }

    public static Drawing loadDrawing(URL uRL, StatusDisplayer statusDisplayer) {
        return DrawingFileHelper.toDrawing(DrawingFileHelper.loadPositionedDrawing(uRL, statusDisplayer));
    }

    public static List<Drawing> loadDrawingList(URL uRL, StatusDisplayer statusDisplayer) {
        return DrawingFileHelper.toDrawingList(DrawingFileHelper.loadPositionedDrawingList(uRL, statusDisplayer));
    }

    public static PositionedDrawing loadPositionedDrawing(File file, StatusDisplayer statusDisplayer) {
        List<PositionedDrawing> list = DrawingFileHelper.loadPositionedDrawingList(file, statusDisplayer);
        int n = list.size();
        if (n == 0) {
            return null;
        }
        if (n > 1) {
            logger.warn((Object)("Loaded multiple nets from " + String.valueOf(file) + ", but only creating a drawing for the first"));
        }
        return list.get(0);
    }

    public static List<PositionedDrawing> loadPositionedDrawingList(File file, StatusDisplayer statusDisplayer) {
        if (statusDisplayer == null) {
            statusDisplayer = DrawPlugin.getGui();
        }
        try {
            URL uRL = file.toURI().toURL();
            List<PositionedDrawing> list = DrawingFileHelper.loadPositionedDrawingList(uRL, statusDisplayer);
            if (list != null) {
                for (PositionedDrawing positionedDrawing : list) {
                    Drawing drawing = positionedDrawing.getDrawing();
                    if (drawing == null) continue;
                    drawing.setName(StringUtil.getFilename((String)file.getName()));
                    drawing.setFilename(file);
                }
            }
            return list;
        }
        catch (IOException iOException) {
            statusDisplayer.showStatus("Error " + String.valueOf(iOException));
            return Collections.emptyList();
        }
    }

    public static PositionedDrawing loadPositionedDrawing(InputStream inputStream, String string) throws FileNotFoundException, IOException {
        Drawing drawing;
        logger.debug((Object)("Loading drawing from " + String.valueOf(inputStream) + "..."));
        PositionedDrawing positionedDrawing = loader.readFromStorableInput(inputStream);
        if (positionedDrawing != null && (drawing = positionedDrawing.getDrawing()) != null) {
            drawing.setName(string);
            if (drawing instanceof Figure) {
                ((Figure)((Object)drawing)).invalidate();
            }
        }
        return positionedDrawing;
    }

    public static PositionedDrawing loadPositionedDrawing(URL uRL, StatusDisplayer statusDisplayer) {
        List<PositionedDrawing> list = DrawingFileHelper.loadPositionedDrawingList(uRL, statusDisplayer);
        int n = list.size();
        if (n == 0) {
            return null;
        }
        if (n > 1) {
            logger.warn((Object)("Loaded multiple nets from " + String.valueOf(uRL) + ", but only creating a drawing for the first"));
        }
        return list.get(0);
    }

    public static List<PositionedDrawing> loadPositionedDrawingList(URL uRL, StatusDisplayer statusDisplayer) {
        Object object;
        logger.debug((Object)("Loading drawing from " + String.valueOf(uRL) + "..."));
        if (statusDisplayer == null) {
            statusDisplayer = DrawPlugin.getGui();
        }
        if (DrawPlugin.getCurrent() != null) {
            for (ImportFormat importFormat : object = DrawPlugin.getCurrent().getImportHolder().allImportFormats()) {
                if (!importFormat.canImport(uRL)) continue;
                try {
                    List<Drawing> list = importFormat.importFiles(new URL[]{uRL});
                    ArrayList<PositionedDrawing> arrayList = new ArrayList<PositionedDrawing>(list.size());
                    for (Drawing drawing : list) {
                        arrayList.add(new PositionedDrawing(null, null, drawing));
                    }
                    return arrayList;
                }
                catch (Exception exception) {
                    logger.error((Object)exception.getMessage());
                    logger.debug((Object)exception);
                }
            }
        }
        try {
            object = loader.readFromStorableInput(uRL, statusDisplayer);
            if (object != null) {
                Drawing drawing = ((PositionedDrawing)object).getDrawing();
                if (drawing != null) {
                    String string = uRL.getFile();
                    drawing.setName(StringUtil.getFilename((String)string));
                    drawing.setFilename(new File(string));
                    if (drawing instanceof Figure) {
                        ((Figure)((Object)drawing)).invalidate();
                    }
                }
                return Collections.singletonList(object);
            }
        }
        catch (IOException iOException) {
            logger.error((Object)("Could not open Drawing: " + uRL.toString()));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(DrawingFileHelper.class.getSimpleName() + ": " + String.valueOf(iOException)));
            }
            statusDisplayer.showStatus("Error " + String.valueOf(iOException));
        }
        return Collections.emptyList();
    }

    public static File deriveBackupFile(File file) {
        File file2 = new File(file.getParent(), StringUtil.stripFilenameExtension((String)file.getName()) + ".bak");
        if (file2.equals(file)) {
            return null;
        }
        return file2;
    }

    public static boolean saveDrawing(Drawing drawing, File file, StatusDisplayer statusDisplayer) {
        return DrawingFileHelper.savePositionedDrawing(new PositionedDrawing(null, null, drawing), file, statusDisplayer);
    }

    public static boolean savePositionedDrawing(PositionedDrawing positionedDrawing, File file, StatusDisplayer statusDisplayer) {
        File file2;
        Drawing drawing = positionedDrawing.getDrawing();
        if (!drawing.getBackupStatus() && (file2 = DrawingFileHelper.deriveBackupFile(file)) != null && file.exists()) {
            logger.debug((Object)("Creating backup file " + String.valueOf(file2) + "..."));
            if (file.renameTo(file2)) {
                drawing.setBackupStatus(true);
            } else {
                logger.error((Object)("Could not create backup file " + String.valueOf(file2) + "!"));
                logger.error((Object)("Original filename is " + String.valueOf(file)));
            }
        }
        logger.debug((Object)("Saving drawing as " + String.valueOf(file) + "..."));
        try {
            DrawingFileHelper.saveAsStorableOutput(drawing, file, positionedDrawing.getWindowLocation(), positionedDrawing.getWindowDimension(), true);
            return true;
        }
        catch (IOException iOException) {
            statusDisplayer.showStatus("Error " + String.valueOf(iOException));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveAsStorableOutput(Drawing drawing, File file, Point point, Dimension dimension, boolean bl) throws IOException {
        drawing.lock();
        try {
            StorableOutput storableOutput = new StorableOutput(file);
            storableOutput.writeInt(11);
            storableOutput.writeStorable(drawing);
            if (point != null && dimension != null) {
                storableOutput.writeInt(point.x);
                storableOutput.writeInt(point.y);
                storableOutput.writeInt(dimension.width);
                storableOutput.writeInt(dimension.height);
            }
            storableOutput.close();
            if (bl) {
                drawing.clearModified();
            }
        }
        finally {
            drawing.unlock();
        }
    }

    public static File checkAndAddExtension(File file, SimpleFileFilter simpleFileFilter) {
        File file2 = file;
        if (file != null && simpleFileFilter != null && !simpleFileFilter.accept(file)) {
            file2 = new File(file.getParentFile(), file.getName() + "." + simpleFileFilter.getExtension());
        }
        return file2;
    }

    public static void setStorableInputDrawingLoader(StorableInputDrawingLoader storableInputDrawingLoader) {
        if (storableInputDrawingLoader == null) {
            throw new NullPointerException("Cannot set null reference as loader.");
        }
        loader = storableInputDrawingLoader;
    }
}

