/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.util.Storable;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Color;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class FigureAttributes
implements Cloneable,
Serializable {
    private static Logger logger = Logger.getLogger(FigureAttributes.class);
    private static final long serialVersionUID = -6886355144423666716L;
    private Hashtable<String, Object> fMap = new Hashtable();
    private int figureAttributesSerializedDataVersion = 1;

    public Object get(String string) {
        return this.fMap.get(string);
    }

    public void set(String string, Object object) {
        if (object == null) {
            this.fMap.remove(string);
        } else {
            this.fMap.put(string, object);
        }
    }

    public boolean hasDefined(String string) {
        return this.fMap.containsKey(string);
    }

    public Enumeration<String> definedAttributes() {
        return this.fMap.keys();
    }

    public Object clone() {
        try {
            FigureAttributes figureAttributes = (FigureAttributes)super.clone();
            figureAttributes.fMap = new Hashtable<String, Object>(this.fMap);
            return figureAttributes;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public void read(StorableInput storableInput) throws IOException {
        String string = storableInput.readString();
        if (!string.toLowerCase().equals("attributes")) {
            throw new IOException("Attributes expected");
        }
        int n = storableInput.getVersion();
        int n2 = storableInput.readInt();
        for (int i = 0; i < n2; ++i) {
            String string2 = storableInput.readString();
            String string3 = storableInput.readString();
            Object object = null;
            if (string3.equals("Color")) {
                object = n < 11 ? new Color(storableInput.readInt(), storableInput.readInt(), storableInput.readInt()) : new Color(storableInput.readInt(), storableInput.readInt(), storableInput.readInt(), storableInput.readInt());
            } else if (string3.equals("Boolean")) {
                object = new Boolean(storableInput.readString());
            } else if (string3.equals("String")) {
                object = storableInput.readString();
            } else if (string3.equals("Int")) {
                object = new Integer(storableInput.readInt());
            } else if (string3.equals("Storable")) {
                object = storableInput.readStorable();
            } else if (string3.equals("UNKNOWN")) continue;
            this.fMap.put(string2, object);
        }
    }

    public void write(StorableOutput storableOutput) {
        storableOutput.writeString("attributes");
        storableOutput.writeInt(this.fMap.size());
        Enumeration<String> enumeration = this.fMap.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            storableOutput.writeString(string);
            Object object = this.fMap.get(string);
            if (object instanceof String) {
                storableOutput.writeString("String");
                storableOutput.writeString((String)object);
                continue;
            }
            if (object instanceof Color) {
                storableOutput.writeString("Color");
                storableOutput.writeInt(((Color)object).getRed());
                storableOutput.writeInt(((Color)object).getGreen());
                storableOutput.writeInt(((Color)object).getBlue());
                storableOutput.writeInt(((Color)object).getAlpha());
                continue;
            }
            if (object instanceof Boolean) {
                storableOutput.writeString("Boolean");
                if (((Boolean)object).booleanValue()) {
                    storableOutput.writeString("TRUE");
                    continue;
                }
                storableOutput.writeString("FALSE");
                continue;
            }
            if (object instanceof Integer) {
                storableOutput.writeString("Int");
                storableOutput.writeInt((Integer)object);
                continue;
            }
            if (object instanceof Storable) {
                storableOutput.writeString("Storable");
                storableOutput.writeStorable((Storable)object);
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(FigureAttributes.class.getSimpleName() + ": Unknown attribute type: " + String.valueOf(object)));
            }
            storableOutput.writeString("UNKNOWN");
        }
    }
}

