/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.pnml.parser;

import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.ChildFigure;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import de.renew.gui.CPNDrawing;
import de.renew.gui.CPNTextFigure;
import de.renew.gui.pnml.converter.Converter;
import de.renew.gui.pnml.parser.AnnotationParser;
import de.renew.gui.pnml.parser.ArcParser;
import de.renew.gui.pnml.parser.ElementParser;
import de.renew.gui.pnml.parser.NodeParser;
import de.renew.gui.pnml.parser.ObjectParser;
import de.renew.gui.pnml.parser.PlaceParser;
import de.renew.gui.pnml.parser.TransitionParser;
import de.renew.gui.pnml.parser.VirtualplaceParser;
import java.awt.Point;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class NetParser
extends ElementParser {
    private int _maxId = 0;
    private Hashtable<String, Integer> _mapping = new Hashtable();
    private Drawing _net;

    public NetParser(Element element) {
        super(element, null);
    }

    private void trySetMaxId(Integer n) {
        int n2 = n;
        if (this._maxId < n2) {
            this._maxId = n2;
        }
    }

    public Drawing getNet() {
        return this._net;
    }

    private void makeOffset() {
        Figure figure;
        int n = 0;
        int n2 = 0;
        FigureEnumeration figureEnumeration = this._net.figures();
        while (figureEnumeration.hasMoreElements()) {
            figure = (Figure)figureEnumeration.nextElement();
            Point point = figure.center();
            if (point.x < n) {
                n = point.x - figure.size().width / 2;
            }
            if (point.y >= n2) continue;
            n2 = point.y - figure.size().height / 2;
        }
        if (n < 0 || n2 < 0) {
            figureEnumeration = this._net.figures();
            n *= -1;
            n2 *= -1;
            while (figureEnumeration.hasMoreElements()) {
                figure = (Figure)figureEnumeration.nextElement();
                if (figure instanceof ChildFigure) {
                    if (((ChildFigure)figure).parent() != null) continue;
                    figure.moveBy(n, n2);
                    continue;
                }
                figure.moveBy(n, n2);
            }
        }
    }

    private void addAnnotations(ObjectParser objectParser) {
        while (objectParser.hasMoreAnnotations()) {
            TextFigure textFigure = objectParser.nextAnnotation();
            if (textFigure == null) continue;
            ++this._maxId;
            textFigure.setID(this._maxId);
            this._net.add((Figure)textFigure);
        }
    }

    private void work(Iterator<ObjectParser> iterator) {
        while (iterator.hasNext()) {
            ObjectParser objectParser = iterator.next();
            if (!objectParser.hasNumericId()) {
                ++this._maxId;
                objectParser.setMappedId(new Integer(this._maxId));
                this._mapping.put(objectParser.getPNMLId(), new Integer(this._maxId));
            }
            this._net.add((Figure)objectParser.getFigure());
            this.addAnnotations(objectParser);
        }
    }

    @Override
    public void doParse() {
        TextFigure textFigure;
        AnnotationParser annotationParser;
        Object object;
        Object object2;
        Object object3;
        Element element;
        int n;
        this._net = new CPNDrawing();
        String string = this.getElement().getAttribute("type");
        Converter converter = new Converter(string);
        this.setNetConverter(converter.getNetConverter());
        LinkedList<PlaceParser> linkedList = new LinkedList<PlaceParser>();
        LinkedList<NodeParser> linkedList2 = new LinkedList<NodeParser>();
        LinkedList<ObjectParser> linkedList3 = new LinkedList<ObjectParser>();
        LinkedList<Object> linkedList4 = new LinkedList<Object>();
        NodeList nodeList = this.getElement().getElementsByTagName("place");
        NodeList nodeList2 = this.getElement().getElementsByTagName("transition");
        NodeList nodeList3 = this.getElement().getElementsByTagName("arc");
        NodeList nodeList4 = this.getElement().getElementsByTagName("toolspecific");
        for (n = 0; n < nodeList.getLength(); ++n) {
            element = (Element)nodeList.item(n);
            object3 = new PlaceParser(element, this.getNetConverter());
            linkedList.add((PlaceParser)object3);
            ((ElementParser)object3).parse();
            if (!((ObjectParser)object3).hasNumericId()) continue;
            this.trySetMaxId(((ObjectParser)object3).getMappedId());
        }
        for (n = 0; n < nodeList2.getLength(); ++n) {
            element = (Element)nodeList2.item(n);
            object3 = new TransitionParser(element, this.getNetConverter());
            linkedList2.add((NodeParser)object3);
            ((ElementParser)object3).parse();
            if (!((ObjectParser)object3).hasNumericId()) continue;
            this.trySetMaxId(((ObjectParser)object3).getMappedId());
        }
        for (n = 0; n < nodeList3.getLength(); ++n) {
            element = (Element)nodeList3.item(n);
            object3 = new ArcParser(element, this._mapping, this._net, this.getNetConverter());
            linkedList3.add((ObjectParser)object3);
            ((ElementParser)object3).parse();
            if (!((ObjectParser)object3).hasNumericId()) continue;
            this.trySetMaxId(((ObjectParser)object3).getMappedId());
        }
        for (n = 0; n < nodeList4.getLength(); ++n) {
            element = (Element)nodeList4.item(n);
            if (!element.getAttribute("tool").equals("renew")) continue;
            object3 = element.getElementsByTagName("VirtualPlace");
            if (object3.getLength() > 0) {
                object2 = (Element)object3.item(0);
                object = new VirtualplaceParser((Element)object2, this._net, this.getNetConverter());
                linkedList4.add(object);
                ((ElementParser)object).parse();
                if (((ObjectParser)object).hasNumericId()) {
                    this.trySetMaxId(((ObjectParser)object).getMappedId());
                }
            }
            if ((object2 = element.getElementsByTagName("declaration")).getLength() <= 0) continue;
            object = (Element)object2.item(0);
            annotationParser = new AnnotationParser((Element)object, this.getNetConverter());
            annotationParser.parse();
            textFigure = annotationParser.getFigure();
            if (textFigure == null) continue;
            this._net.add((Figure)textFigure);
        }
        NodeList nodeList5 = this.getElement().getChildNodes();
        for (int i = 0; i < nodeList5.getLength(); ++i) {
            object3 = nodeList5.item(i);
            if (object3.getNodeType() != 1) continue;
            object2 = (Element)object3;
            if (!this.getNetConverter().isAnnotation((Element)object2)) continue;
            object = new AnnotationParser((Element)object3, this.getNetConverter());
            ((ElementParser)object).parse();
            annotationParser = ((AnnotationParser)object).getFigure();
            ++this._maxId;
            if (annotationParser == null) continue;
            annotationParser.setID(this._maxId);
            if (annotationParser instanceof CPNTextFigure && (textFigure = (CPNTextFigure)((Object)annotationParser)).getType() == 2) {
                this._net.setName(textFigure.getText());
                continue;
            }
            this._net.add((Figure)annotationParser);
        }
        Iterator<ObjectParser> iterator = linkedList.iterator();
        this.work(iterator);
        iterator = linkedList4.iterator();
        this.work(iterator);
        iterator = linkedList2.iterator();
        this.work(iterator);
        iterator = linkedList3.iterator();
        this.work(iterator);
        this.makeOffset();
    }
}

