/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.pnml.parser;

import de.renew.gui.pnml.converter.GraphicConverter;
import de.renew.gui.pnml.converter.NetConverter;
import de.renew.gui.pnml.parser.ElementParser;
import java.awt.Color;
import java.awt.Point;
import java.util.Iterator;
import java.util.LinkedList;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GraphicParser
extends ElementParser {
    private NodeList positions;
    private NodeList dimension;
    private Element offSet;
    private Element fill;
    private Element line;

    private static int parseRoundDouble(String string) {
        return (int)Math.round(Double.parseDouble(string));
    }

    public GraphicParser(Element element, NetConverter netConverter) {
        super(element, netConverter);
    }

    @Override
    protected void doParse() {
        if (this.getElement() != null) {
            this.positions = this.getElement().getElementsByTagName("position");
            this.dimension = this.getElement().getElementsByTagName("dimension");
            NodeList nodeList = this.getElement().getElementsByTagName("offset");
            if (nodeList.getLength() > 0) {
                this.offSet = (Element)nodeList.item(0);
            }
            if ((nodeList = this.getElement().getElementsByTagName("fill")).getLength() > 0) {
                this.fill = (Element)nodeList.item(0);
            }
            if ((nodeList = this.getElement().getElementsByTagName("line")).getLength() > 0) {
                this.line = (Element)nodeList.item(0);
            }
        }
    }

    public Iterator<Point> positions() {
        LinkedList<Point> linkedList = new LinkedList<Point>();
        if (this.positions != null) {
            for (int i = 0; i < this.positions.getLength(); ++i) {
                Element element = (Element)this.positions.item(i);
                int n = GraphicParser.parseRoundDouble(element.getAttribute("x"));
                int n2 = GraphicParser.parseRoundDouble(element.getAttribute("y"));
                linkedList.add(new Point(n, n2));
            }
        }
        return linkedList.iterator();
    }

    public boolean hasPosition() {
        return this.positions != null && this.positions.getLength() > 0;
    }

    public Point getDimension() {
        if (this.dimension == null || this.dimension.getLength() == 0) {
            return null;
        }
        Point point = new Point();
        Element element = (Element)this.dimension.item(0);
        point.x = GraphicParser.parseRoundDouble(element.getAttribute("x"));
        point.y = GraphicParser.parseRoundDouble(element.getAttribute("y"));
        return point;
    }

    public int offsetX() {
        if (this.offSet == null) {
            return 0;
        }
        return GraphicParser.parseRoundDouble(this.offSet.getAttribute("x"));
    }

    public int offsetY() {
        if (this.offSet == null) {
            return 0;
        }
        return GraphicParser.parseRoundDouble(this.offSet.getAttribute("y"));
    }

    public boolean hasFill() {
        return this.fill != null;
    }

    public Color getFill() {
        if (!this.hasFill()) {
            return null;
        }
        String string = this.fill.getAttribute("color");
        return GraphicConverter.instance().parseCSS2Color(string);
    }

    public boolean hasLine() {
        return this.line != null;
    }

    public boolean hasLineColor() {
        return this.line != null && !"".equals(this.line.getAttribute("color"));
    }

    public Color getLineColor() {
        if (!this.hasLineColor()) {
            return null;
        }
        String string = this.line.getAttribute("color");
        return GraphicConverter.instance().parseCSS2Color(string);
    }

    public boolean hasLineStyle() {
        return this.line != null && !"".equals(this.line.getAttribute("style"));
    }

    public String getLineStyle() {
        if (!this.hasLineStyle()) {
            return null;
        }
        String string = this.line.getAttribute("style");
        return GraphicConverter.instance().parsePNMLLineStyle(string);
    }
}

