/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.pnml.creator;

import CH.ifa.draw.framework.FigureWithID;
import de.renew.gui.ArcConnection;
import de.renew.gui.VirtualPlaceFigure;
import de.renew.gui.pnml.converter.Converter;
import de.renew.gui.pnml.creator.AttributeCreator;
import de.renew.gui.pnml.creator.GraphicCreator;
import de.renew.gui.pnml.creator.ObjectCreator;
import de.renew.gui.pnml.creator.PNMLCreator;
import java.awt.Color;
import java.awt.Point;
import org.w3c.dom.Element;

public class ArcCreator
extends ObjectCreator {
    private VirtualPlaceFigure virStart = null;
    private VirtualPlaceFigure virEnd = null;

    public ArcCreator(Converter converter) {
        super("arc", converter);
    }

    public void setVirStart(VirtualPlaceFigure virtualPlaceFigure) {
        this.virStart = virtualPlaceFigure;
    }

    public void setVirEnd(VirtualPlaceFigure virtualPlaceFigure) {
        this.virEnd = virtualPlaceFigure;
    }

    protected ArcConnection getArc() {
        return (ArcConnection)this.getFigure();
    }

    @Override
    protected void doCreateAttribute(PNMLCreator pNMLCreator, Element element) {
        String string;
        switch (this.getArc().getArcType()) {
            case 2: {
                string = "both";
                break;
            }
            case 3: {
                string = "inhibitor";
                break;
            }
            case 0: {
                string = "test";
                break;
            }
            case 5: {
                string = "clear";
                break;
            }
            case 4: {
                string = "multi-ordinary";
                break;
            }
            default: {
                return;
            }
        }
        AttributeCreator attributeCreator = new AttributeCreator(pNMLCreator, "type");
        element.appendChild(attributeCreator.createElement(string));
    }

    @Override
    protected void doCreateGraphic(GraphicCreator graphicCreator) {
        Object object;
        int n = this.getArc().pointCount();
        for (int i = 1; i < n - 1; ++i) {
            object = this.getArc().pointAt(i);
            graphicCreator.addPosition(((Point)object).x, ((Point)object).y);
        }
        Color color = (Color)this.getFigure().getAttribute("FrameColor");
        graphicCreator.addLineColor(color);
        object = (String)this.getFigure().getAttribute("LineStyle");
        graphicCreator.addLineStyle((String)object);
        graphicCreator.addLine();
    }

    @Override
    protected void doCreateObject(PNMLCreator pNMLCreator, Element element) {
        FigureWithID figureWithID = (FigureWithID)this.getArc().startFigure();
        FigureWithID figureWithID2 = (FigureWithID)this.getArc().endFigure();
        element.setAttribute("source", this.xmlID(figureWithID));
        element.setAttribute("target", this.xmlID(figureWithID2));
        if (this.virStart != null || this.virEnd != null) {
            Element element2 = pNMLCreator.createToolspecific();
            if (this.virStart != null) {
                element2.setAttribute("source", this.xmlID((FigureWithID)this.virStart));
            }
            if (this.virEnd != null) {
                element2.setAttribute("target", this.xmlID((FigureWithID)this.virEnd));
            }
            element.appendChild(element2);
        }
    }
}

