/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeAdapter;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.FigureChangeListener;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.standard.MergedFigureEnumerator;
import CH.ifa.draw.util.Storable;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import de.renew.gui.PlaceFigure;
import de.renew.shadow.ShadowNet;
import de.renew.shadow.ShadowNetElement;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Vector;

public class VirtualPlaceFigure
extends PlaceFigure {
    private static final long serialVersionUID = -7877776241236946511L;
    private int virtualPlaceFigureSerializedDataVersion = 1;
    private PlaceFigure place = null;

    public VirtualPlaceFigure() {
    }

    public VirtualPlaceFigure(PlaceFigure placeFigure) {
        this.setPlace(placeFigure);
    }

    private void setPlace(PlaceFigure placeFigure) {
        this.place = placeFigure;
        this.adapt();
        final FigureChangeEvent figureChangeEvent = new FigureChangeEvent((Figure)this, null);
        placeFigure.addFigureChangeListener((FigureChangeListener)new FigureChangeAdapter(){

            public void figureChanged(FigureChangeEvent figureChangeEvent2) {
                VirtualPlaceFigure.this.adapt();
            }

            public void figureRemoved(FigureChangeEvent figureChangeEvent2) {
                if (VirtualPlaceFigure.this.listener() != null) {
                    VirtualPlaceFigure.this.listener().figureRequestRemove(figureChangeEvent);
                }
            }
        });
    }

    @Override
    public PlaceFigure getSemanticPlaceFigure() {
        return this.place.getSemanticPlaceFigure();
    }

    private void adapt() {
        super.setAttribute("FillColor", (Object)this.place.getFillColor());
        super.setAttribute("FrameColor", (Object)this.place.getFrameColor());
    }

    public void drawFrame(Graphics graphics) {
        super.drawFrame(graphics);
        Rectangle rectangle = this.displayBox();
        Ellipse2D.Double double_ = new Ellipse2D.Double(rectangle.x + 2, rectangle.y + 2, rectangle.width - 4, rectangle.height - 4);
        ((Graphics2D)graphics).draw(double_);
    }

    @Override
    public ShadowNetElement buildShadow(ShadowNet shadowNet) {
        return null;
    }

    @Override
    public ShadowNetElement getShadow() {
        return this.place.getShadow();
    }

    public void setAttribute(String string, Object object) {
        if ("FillColor".equals(string) || "FrameColor".equals(string)) {
            this.place.setAttribute(string, object);
        } else {
            super.setAttribute(string, object);
        }
    }

    public boolean inspect(DrawingView drawingView, boolean bl) {
        if (bl) {
            return super.inspect(drawingView, true);
        }
        drawingView.clearSelection();
        drawingView.addToSelection((Figure)this.place);
        return true;
    }

    @Override
    public FigureEnumeration getFiguresWithDependencies() {
        FigureEnumeration figureEnumeration = super.getFiguresWithDependencies();
        Vector<PlaceFigure> vector = new Vector<PlaceFigure>(1);
        vector.addElement(this.place);
        return new MergedFigureEnumerator(figureEnumeration, (FigureEnumeration)new FigureEnumerator(vector));
    }

    @Override
    public void write(StorableOutput storableOutput) {
        super.write(storableOutput);
        storableOutput.writeStorable((Storable)this.place);
    }

    @Override
    public void read(StorableInput storableInput) throws IOException {
        super.read(storableInput);
        this.setPlace((PlaceFigure)storableInput.readStorable());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.setPlace(this.place);
    }
}

