/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeAdapter;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.FigureChangeListener;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.standard.FigureException;
import de.renew.formalism.java.ConstructorSuggestion;
import de.renew.formalism.java.FieldSuggestion;
import de.renew.formalism.java.MethodSuggestion;
import de.renew.formalism.java.Suggestion;
import de.renew.formalism.java.VariableSuggestion;
import de.renew.gui.CPNApplication;
import de.renew.gui.DeclarationFigure;
import de.renew.gui.GuiPlugin;
import de.renew.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

class SyntaxExceptionFrame
extends FigureChangeAdapter {
    private final JFrame frame;
    private final JButton selectButton;
    private final JTextArea textArea;
    private final CPNApplication editor;
    private FigureException e = null;
    private JPanel myPanel;
    private JList listOfSuggestions;
    private DefaultListModel listModel;
    private JTextArea methodListHeader;
    private JScrollPane scrollPane;
    private JButton applyButton;
    private QuickfixListener quickfixListener;

    SyntaxExceptionFrame(final CPNApplication cPNApplication) {
        this.editor = cPNApplication;
        this.frame = new JFrame("Renew: Syntax Error");
        this.frame.setIconImage(Toolkit.getDefaultToolkit().createImage(cPNApplication.getIconImage().getSource()));
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        this.frame.getContentPane().add("Center", this.textArea);
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        this.frame.getContentPane().add("South", jPanel);
        JButton jButton = new JButton("Close");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SyntaxExceptionFrame.this.frame.dispose();
            }
        });
        this.selectButton = new JButton("Select");
        this.selectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GuiPlugin.getCurrent().getGui().showDrawingViewContainer(SyntaxExceptionFrame.this.e.errorDrawing);
                if (SyntaxExceptionFrame.this.e != null && !cPNApplication.selectOffendingElements(SyntaxExceptionFrame.this.e)) {
                    SyntaxExceptionFrame.this.selectButton.setEnabled(false);
                }
            }
        });
        this.applyButton = new JButton("Apply");
        this.applyButton.setEnabled(false);
        jPanel.add("1", jButton);
        jPanel.add("2", this.selectButton);
        jPanel.add("3", this.applyButton);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SyntaxExceptionFrame.this.dispose();
            }
        });
        this.frame.getRootPane().setDefaultButton(this.selectButton);
    }

    void displayException(FigureException figureException, boolean bl) {
        if (bl) {
            this.selectButton.setEnabled(this.editor.selectOffendingElements(figureException));
        } else {
            this.selectButton.setEnabled(true);
        }
        this.e = figureException;
        this.setFrame();
        FigureEnumerator figureEnumerator = new FigureEnumerator(figureException.errorFigures);
        while (figureEnumerator.hasMoreElements()) {
            figureEnumerator.nextFigure().addFigureChangeListener((FigureChangeListener)this);
        }
        this.frame.pack();
        this.frame.setVisible(true);
    }

    private void setFrame() {
        String string = this.e.getMessage();
        this.frame.setTitle(this.e.title);
        Object object = this.e.getProblemSpecificInformation();
        if (object == null) {
            if (this.myPanel != null) {
                this.frame.remove(this.myPanel);
            }
            this.textArea.setText(string);
            this.frame.getContentPane().add("Center", this.textArea);
            this.applyButton.setEnabled(false);
            this.frame.getRootPane().setDefaultButton(this.selectButton);
        } else {
            if (this.quickfixListener == null) {
                this.quickfixListener = new QuickfixListener();
                this.applyButton.addActionListener(this.quickfixListener);
            }
            this.applyButton.setEnabled(true);
            this.frame.getRootPane().setDefaultButton(this.applyButton);
            if (this.listOfSuggestions == null) {
                this.listOfSuggestions = new JList();
                this.listOfSuggestions.addMouseListener(this.quickfixListener);
                this.listOfSuggestions.addKeyListener(this.quickfixListener);
                this.frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowOpened(WindowEvent windowEvent) {
                        SyntaxExceptionFrame.this.listOfSuggestions.requestFocus();
                    }
                });
            }
            if (this.myPanel == null) {
                this.myPanel = new JPanel();
                this.myPanel.setLayout(new BorderLayout());
            }
            this.listModel = new DefaultListModel();
            if (this.methodListHeader == null) {
                this.methodListHeader = new JTextArea();
                this.methodListHeader.setEditable(false);
                this.methodListHeader.setEnabled(false);
            }
            if (this.scrollPane == null) {
                this.scrollPane = new JScrollPane();
                this.scrollPane.setViewportView(this.listOfSuggestions);
            }
            this.methodListHeader.setText(string);
            this.frame.remove(this.textArea);
            if (object instanceof Collection && !((Collection)object).isEmpty() && ((Collection)object).iterator().next() instanceof Suggestion) {
                for (Suggestion suggestion : (Collection)object) {
                    this.listModel.addElement(suggestion);
                }
            }
            this.listOfSuggestions.setModel(this.listModel);
            if (!this.listModel.isEmpty()) {
                this.listOfSuggestions.setSelectedIndex(0);
            }
            this.myPanel.add((Component)this.methodListHeader, "North");
            this.myPanel.add((Component)this.scrollPane, "Center");
            this.frame.getContentPane().add("Center", this.myPanel);
        }
    }

    public void figureRemoved(FigureChangeEvent figureChangeEvent) {
        this.dispose();
    }

    public void dispose() {
        if (this.e != null) {
            this.frame.dispose();
            FigureEnumerator figureEnumerator = new FigureEnumerator(this.e.errorFigures);
            while (figureEnumerator.hasMoreElements()) {
                figureEnumerator.nextFigure().removeFigureChangeListener((FigureChangeListener)this);
            }
            this.e = null;
        }
    }

    private class QuickfixListener
    implements MouseListener,
    KeyListener,
    ActionListener {
        private QuickfixListener() {
        }

        private void quickfix() {
            Object e = SyntaxExceptionFrame.this.listOfSuggestions.getSelectedValue();
            SyntaxExceptionFrame.this.editor.getUndoRedoManager().commitUndoSnapshot(SyntaxExceptionFrame.this.editor.drawing());
            if (e instanceof Suggestion) {
                TextFigure textFigure;
                Object object;
                int n;
                boolean bl;
                boolean bl2;
                TextFigure textFigure2 = SyntaxExceptionFrame.this.e.textErrorFigure;
                String string = textFigure2.getText();
                int n2 = this.getIndexFromLineAndColumn(string, SyntaxExceptionFrame.this.e.line, SyntaxExceptionFrame.this.e.column);
                String string2 = string.substring(0, n2);
                Object object2 = string.substring(n2);
                int n3 = SyntaxExceptionFrame.this.e.line;
                int n4 = SyntaxExceptionFrame.this.e.line;
                int n5 = SyntaxExceptionFrame.this.e.column;
                if (e instanceof MethodSuggestion) {
                    bl2 = true;
                    MethodSuggestion methodSuggestion = (MethodSuggestion)e;
                    String string3 = methodSuggestion.getAttemptedMethod();
                    Class[] classArray = methodSuggestion.getAttemptedTypes();
                    Class<?>[] classArray2 = methodSuggestion.getMethod().getParameterTypes();
                    boolean bl3 = false;
                    if (classArray.length == classArray2.length) {
                        bl3 = true;
                        for (int i = 0; i < classArray.length; ++i) {
                            if (this.collectTypes(classArray[i]).contains(classArray2[i])) continue;
                            bl3 = false;
                        }
                    }
                    if (bl3) {
                        object2 = ((String)object2).replaceFirst(string3, methodSuggestion.getName());
                        bl = false;
                        n = SyntaxExceptionFrame.this.e.column + ".".length() + methodSuggestion.getName().length();
                    } else if (((String)object2).startsWith("." + string3 + "()")) {
                        object2 = ((String)object2).replaceFirst(string3 + "\\(\\)", methodSuggestion.getCallWithParameters());
                        if (methodSuggestion.getParameters().length > 0) {
                            bl = true;
                            n = SyntaxExceptionFrame.this.e.column + ".".length() + methodSuggestion.getName().length() + "(".length();
                            n5 = n + methodSuggestion.getParameters()[0].length();
                        } else {
                            bl = false;
                            n = SyntaxExceptionFrame.this.e.column + ".".length() + methodSuggestion.getName().length() + "()".length();
                        }
                    } else {
                        object2 = ((String)object2).replaceFirst(string3, methodSuggestion.getCallWithParameters());
                        if (methodSuggestion.getParameters().length > 0) {
                            bl = true;
                            n = SyntaxExceptionFrame.this.e.column + ".".length() + methodSuggestion.getName().length() + "(".length();
                            n5 = n + methodSuggestion.getParameters()[0].length();
                        } else {
                            bl = false;
                            n = SyntaxExceptionFrame.this.e.column + ".".length() + methodSuggestion.getName().length() + "()".length();
                        }
                    }
                    object = string2 + (String)object2;
                    textFigure = textFigure2;
                } else if (e instanceof ConstructorSuggestion) {
                    bl = false;
                    bl2 = false;
                    ConstructorSuggestion constructorSuggestion = (ConstructorSuggestion)e;
                    string2 = string.substring(0, string.indexOf(61) + 1);
                    object2 = " new " + constructorSuggestion.getCallWithParameters();
                    n = string2.length() + constructorSuggestion.getTypeName().length() + 7;
                    if (constructorSuggestion.getParameters().length > 0) {
                        bl = true;
                        bl2 = true;
                        n5 = n + constructorSuggestion.getParameters()[0].length();
                    }
                    object = string2 + (String)object2;
                    textFigure = textFigure2;
                } else if (e instanceof FieldSuggestion) {
                    FieldSuggestion fieldSuggestion = (FieldSuggestion)e;
                    object2 = ((String)object2).replaceFirst(fieldSuggestion.getAttemptedName(), fieldSuggestion.getName());
                    bl = false;
                    bl2 = true;
                    n = SyntaxExceptionFrame.this.e.column + 1 + fieldSuggestion.getName().length();
                    object = string2 + (String)object2;
                    textFigure = textFigure2;
                } else if (e instanceof VariableSuggestion) {
                    Object object3;
                    VariableSuggestion variableSuggestion = (VariableSuggestion)e;
                    bl = true;
                    bl2 = variableSuggestion.isEditDesired();
                    FigureEnumeration figureEnumeration = SyntaxExceptionFrame.this.e.errorDrawing.figures();
                    DeclarationFigure declarationFigure = null;
                    while (figureEnumeration.hasMoreElements()) {
                        object3 = (Figure)figureEnumeration.nextElement();
                        if (!(object3 instanceof DeclarationFigure)) continue;
                        declarationFigure = (DeclarationFigure)object3;
                        break;
                    }
                    if (declarationFigure == null) {
                        throw new RuntimeException("no declaration node found.");
                    }
                    object = declarationFigure.getText();
                    n4 = n3 = this.countLines((String)object) + 1;
                    object = (String)object + "\n" + variableSuggestion.getTypeName() + " " + variableSuggestion.getName() + ";";
                    n = 1;
                    n5 = variableSuggestion.getTypeName().length() + 1;
                    if (variableSuggestion.isImportNeeded()) {
                        object3 = "import " + variableSuggestion.getType().getPackage().getName() + ".*;";
                        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(((String)object).split("\n")));
                        int n6 = 0;
                        for (int i = arrayList.size() - 1; i >= 0; --i) {
                            String string4 = (String)arrayList.get(i);
                            if (!string4.startsWith("import")) continue;
                            n6 = i;
                        }
                        if (n6 != 0) {
                            ++n6;
                        }
                        arrayList.add(n6, (String)object3);
                        object = StringUtil.join(arrayList, (String)"\n");
                    }
                    textFigure = declarationFigure;
                } else {
                    throw new RuntimeException("unsupported suggestion type");
                }
                SyntaxExceptionFrame.this.editor.toolDone();
                textFigure.setText((String)object);
                SyntaxExceptionFrame.this.editor.toolDone();
                if (bl2) {
                    if (bl) {
                        SyntaxExceptionFrame.this.editor.doTextEditSelected(textFigure, n3, n, n4, n5);
                    } else {
                        SyntaxExceptionFrame.this.editor.doTextEdit(textFigure, n3, n);
                    }
                }
            }
            SyntaxExceptionFrame.this.dispose();
            SyntaxExceptionFrame.this.listModel.clear();
        }

        private int getIndexFromLineAndColumn(String string, int n, int n2) {
            int n3 = -1;
            String string2 = "^([^\n]*\n){" + (n - 1) + "}.{" + (n2 - 1) + "}";
            Pattern pattern = Pattern.compile(string2);
            Matcher matcher = pattern.matcher(string);
            if (matcher.find()) {
                n3 = matcher.end();
            }
            return n3;
        }

        private int countLines(String string) {
            int n = 1;
            String string2 = "\n";
            Pattern pattern = Pattern.compile(string2);
            Matcher matcher = pattern.matcher(string);
            while (matcher.find()) {
                ++n;
            }
            return n;
        }

        private Set<Class<?>> collectTypes(Class<?> clazz) {
            HashSet hashSet = new HashSet();
            while (clazz != null) {
                hashSet.add(clazz);
                Class<?>[] classArray = clazz.getInterfaces();
                List<Class<?>> list = Arrays.asList(classArray);
                hashSet.addAll(list);
                clazz = clazz.getSuperclass();
            }
            return hashSet;
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                this.quickfix();
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                this.quickfix();
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.quickfix();
        }
    }
}

