/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import de.renew.application.NoSimulationException;
import de.renew.application.SimulatorPlugin;
import de.renew.formalism.FormalismPlugin;
import de.renew.gui.CPNDrawing;
import de.renew.gui.FigureExceptionFactory;
import de.renew.gui.GuiPlugin;
import de.renew.shadow.ShadowCompilerFactory;
import de.renew.shadow.ShadowNetSystem;
import de.renew.shadow.SyntaxException;
import java.awt.EventQueue;
import org.apache.log4j.Logger;

public class NetInstanceBuilder {
    public static Logger logger = Logger.getLogger(NetInstanceBuilder.class);

    public static void buildInstanceFromDrawing(CPNDrawing cPNDrawing) {
        NetInstanceBuilder.buildInstanceFromDrawing(cPNDrawing, FormalismPlugin.getCurrent().getCompiler());
    }

    public static void buildInstanceFromDrawing(CPNDrawing cPNDrawing, String string) {
        FormalismPlugin formalismPlugin = FormalismPlugin.getCurrent();
        NetInstanceBuilder.buildInstanceFromDrawing(cPNDrawing, formalismPlugin.getCompilerFactoryByName(string));
    }

    public static void buildInstanceFromDrawing(CPNDrawing cPNDrawing, ShadowCompilerFactory shadowCompilerFactory) {
        if (!cPNDrawing.getName().equals("untitled")) {
            ShadowNetSystem shadowNetSystem = new ShadowNetSystem(shadowCompilerFactory);
            cPNDrawing.buildShadow(shadowNetSystem);
            SimulatorPlugin simulatorPlugin = SimulatorPlugin.getCurrent();
            try {
                simulatorPlugin.insertNets(shadowNetSystem);
            }
            catch (NoSimulationException noSimulationException) {
                logger.error((Object)"Simulation was terminated befor the new net has been initialized");
            }
            catch (SyntaxException syntaxException) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GuiPlugin.getCurrent().processSyntaxException(FigureExceptionFactory.createFigureException(syntaxException), true);
                    }
                });
            }
        }
    }
}

