/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.AbstractHandle;
import CH.ifa.draw.util.ColorMap;
import de.renew.gui.TokenHandle;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public abstract class ClickHandle
extends AbstractHandle
implements TokenHandle {
    protected Rectangle box;
    protected Color fillColor;
    protected Color penColor;

    protected ClickHandle(Figure figure, Color color, Color color2, Rectangle rectangle) {
        super(figure);
        this.fillColor = color;
        this.penColor = color2;
        this.box = rectangle;
    }

    public Point getOffset() {
        return this.box.getLocation();
    }

    public void setBox(Rectangle rectangle) {
        this.box = rectangle;
    }

    public Point locate() {
        Rectangle rectangle = this.displayBox();
        return new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
    }

    public Rectangle displayBox() {
        Rectangle rectangle = this.owner().displayBox();
        return new Rectangle(this.box.x + rectangle.x, this.box.y + rectangle.y, this.box.width, this.box.height);
    }

    protected void drawInner(Graphics graphics) {
    }

    public void draw(Graphics graphics) {
        Rectangle rectangle = this.owner().displayBox();
        graphics.translate(rectangle.x, rectangle.y);
        if (!ColorMap.NONE.equals(this.fillColor)) {
            graphics.setColor(this.fillColor);
            graphics.fillRect(this.box.x, this.box.y, this.box.width, this.box.height);
        }
        if (!ColorMap.NONE.equals(this.penColor)) {
            graphics.setColor(this.penColor);
            graphics.drawRect(this.box.x, this.box.y, this.box.width - 1, this.box.height - 1);
        }
        this.drawInner(graphics);
        graphics.translate(-rectangle.x, -rectangle.y);
    }
}

