/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import de.renew.gui.GraphLayout;
import de.renew.gui.LayoutableDrawing;
import java.awt.Dimension;
import java.awt.Rectangle;

public class AnnealingGraphLayout {
    public double springLength = 1.0;
    public double springStrength = 0.05;
    public double repulsionDistance = 400.0;
    public double repulsionStrength = 2.0;
    public double torqueStrength = 0.25;
    public double friction = 0.25;
    public int layoutOffset = 65536;
    public int steps = 2048;

    public GraphLayout annealingLayout(LayoutableDrawing layoutableDrawing) {
        GraphLayout graphLayout = new GraphLayout();
        layoutableDrawing.fillInGraph(graphLayout);
        this.randomInit(graphLayout, layoutableDrawing.defaultSize());
        this.anneal(graphLayout);
        int n = 2 * this.layoutOffset;
        graphLayout.moveBy(-n, -n);
        Rectangle rectangle = layoutableDrawing.displayBox();
        graphLayout.moveBy(-rectangle.x, -rectangle.y);
        layoutableDrawing.figureRequestUpdate(null);
        return graphLayout;
    }

    private void randomInit(GraphLayout graphLayout, Dimension dimension) {
        graphLayout.randomInit(this.layoutOffset, this.layoutOffset, dimension.width, dimension.height);
    }

    private void anneal(GraphLayout graphLayout) {
        graphLayout.lengthFactor = this.springLength;
        graphLayout.repulsionLimit = this.repulsionDistance;
        graphLayout.torqueStrength = this.torqueStrength;
        for (int i = 0; i < this.steps; ++i) {
            double d = (double)i / (double)this.steps;
            double d2 = 1.0 + (1.0 - d) * 10.0;
            graphLayout.springStrength = d2 * this.springStrength;
            graphLayout.repulsionStrength = d2 * this.repulsionStrength;
            graphLayout.frictionFactor = 1.0 - d * this.friction;
            graphLayout.relax();
        }
    }
}

