/*
 * Decompiled with CFR 0.152.
 */
package de.renew.remote;

import de.renew.application.SimulationEnvironment;
import de.renew.engine.searcher.Searchable;
import de.renew.engine.searcher.TriggerCollection;
import de.renew.engine.searcher.TriggerCollectionImpl;
import de.renew.engine.searcher.Triggerable;
import de.renew.engine.simulator.Binding;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.engine.simulator.SimulatorHelper;
import de.renew.net.NetElementID;
import de.renew.net.TransitionInstance;
import de.renew.net.event.FiringEvent;
import de.renew.net.event.TransitionEventListener;
import de.renew.remote.BindingAccessor;
import de.renew.remote.BindingAccessorImpl;
import de.renew.remote.NetInstanceAccessor;
import de.renew.remote.NetInstanceAccessorImpl;
import de.renew.remote.ObjectAccessorImpl;
import de.renew.remote.RemoteEventListener;
import de.renew.remote.TransitionAccessor;
import de.renew.remote.TransitionAccessorImpl;
import de.renew.remote.TransitionInstanceAccessor;
import de.renew.remote.TriggerableForwarder;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class TransitionInstanceAccessorImpl
extends ObjectAccessorImpl
implements TransitionInstanceAccessor,
TransitionEventListener,
Triggerable {
    public static Logger logger = Logger.getLogger(TransitionInstanceAccessorImpl.class);
    private Set<RemoteEventListener> firingListeners = Collections.synchronizedSet(new HashSet());
    private Set<TriggerableForwarder> proposalListeners = Collections.synchronizedSet(new HashSet());
    private TriggerCollection triggers = new TriggerCollectionImpl((Triggerable)this);

    public TransitionInstanceAccessorImpl(TransitionInstance transitionInstance, SimulationEnvironment simulationEnvironment) throws RemoteException {
        super(transitionInstance, simulationEnvironment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRemoteEventListener(RemoteEventListener remoteEventListener) throws RemoteException {
        Set<RemoteEventListener> set = this.firingListeners;
        synchronized (set) {
            if (this.firingListeners.isEmpty()) {
                ((TransitionInstance)this.object).addTransitionEventListener((TransitionEventListener)this);
            }
            this.firingListeners.add(remoteEventListener);
        }
    }

    @Override
    public BindingAccessor[] findAllBindings(final TriggerableForwarder triggerableForwarder) throws RemoteException {
        final TransitionInstanceAccessorImpl transitionInstanceAccessorImpl = this;
        Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<BindingAccessor[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public BindingAccessor[] call() throws Exception {
                BindingAccessor[] bindingAccessorArray = TransitionInstanceAccessorImpl.this.proposalListeners;
                synchronized (TransitionInstanceAccessorImpl.this.proposalListeners) {
                    TransitionInstanceAccessorImpl.this.proposalListeners.add(triggerableForwarder);
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    try {
                        TransitionInstanceAccessorImpl.this.triggers.clear();
                        Collection collection = SimulatorHelper.findAllBindings((Searchable)((TransitionInstance)TransitionInstanceAccessorImpl.this.object), (Triggerable)transitionInstanceAccessorImpl);
                        Iterator iterator = collection.iterator();
                        bindingAccessorArray = new BindingAccessor[collection.size()];
                        int n = 0;
                        while (iterator.hasNext()) {
                            bindingAccessorArray[n] = new BindingAccessorImpl((Binding)iterator.next(), TransitionInstanceAccessorImpl.this.getEnvironment());
                            ++n;
                        }
                    }
                    catch (RemoteException remoteException) {
                        logger.error((Object)remoteException.getMessage(), (Throwable)remoteException);
                        bindingAccessorArray = new BindingAccessor[]{};
                    }
                    return bindingAccessorArray;
                }
            }
        });
        try {
            return (BindingAccessor[])future.get();
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            logger.error((Object)"Simulation thread threw an exception", (Throwable)executionException);
        }
        return null;
    }

    @Override
    public void forgetBindings(final TriggerableForwarder triggerableForwarder) throws RemoteException {
        SimulationThreadPool.getCurrent().executeAndWait(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Set<TriggerableForwarder> set = TransitionInstanceAccessorImpl.this.proposalListeners;
                synchronized (set) {
                    TransitionInstanceAccessorImpl.this.proposalListeners.remove(triggerableForwarder);
                    if (TransitionInstanceAccessorImpl.this.proposalListeners.isEmpty()) {
                        TransitionInstanceAccessorImpl.this.triggers.clear();
                    }
                }
            }
        });
    }

    @Override
    public boolean fireOneBinding() throws RemoteException {
        Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                boolean bl = !TransitionInstanceAccessorImpl.this.getEnvironment().getSimulator().isSequential();
                return ((TransitionInstance)TransitionInstanceAccessorImpl.this.object).fireOneBinding(bl);
            }
        });
        try {
            return (Boolean)future.get();
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            logger.error((Object)"Simulation thread threw an exception", (Throwable)executionException);
        }
        return false;
    }

    private void fireRemoteEvent() {
        Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() throws Exception {
                Set<RemoteEventListener> set = TransitionInstanceAccessorImpl.this.firingListeners;
                synchronized (set) {
                    for (RemoteEventListener remoteEventListener : TransitionInstanceAccessorImpl.this.firingListeners) {
                        try {
                            remoteEventListener.update();
                        }
                        catch (RemoteException remoteException) {
                            logger.error((Object)("TransitionInstanceAccessor: Remote event to " + String.valueOf(remoteEventListener) + " probably got lost due to " + String.valueOf(remoteException)));
                        }
                    }
                }
                return null;
            }
        });
        try {
            future.get();
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            logger.error((Object)"Simulation thread threw an exception", (Throwable)executionException);
        }
    }

    public void firingComplete(FiringEvent firingEvent) {
        this.fireRemoteEvent();
    }

    public void firingStarted(FiringEvent firingEvent) {
        this.fireRemoteEvent();
    }

    @Override
    public NetElementID getID() throws RemoteException {
        return ((TransitionInstance)this.object).getTransition().getID();
    }

    @Override
    public TransitionAccessor getTransition() throws RemoteException {
        return new TransitionAccessorImpl(((TransitionInstance)this.object).getTransition(), this.getEnvironment());
    }

    public TransitionInstance getTransitionInstance() {
        return (TransitionInstance)this.object;
    }

    @Override
    public NetInstanceAccessor getNetInstance() throws RemoteException {
        return new NetInstanceAccessorImpl(((TransitionInstance)this.object).getNetInstance(), this.getEnvironment());
    }

    @Override
    public boolean isFiring() throws RemoteException {
        return ((TransitionInstance)this.object).isFiring();
    }

    public synchronized void proposeSearch() {
        Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() throws Exception {
                ArrayList<TriggerableForwarder> arrayList;
                Object object = TransitionInstanceAccessorImpl.this.proposalListeners;
                synchronized (object) {
                    arrayList = new ArrayList<TriggerableForwarder>(TransitionInstanceAccessorImpl.this.proposalListeners);
                    TransitionInstanceAccessorImpl.this.proposalListeners.clear();
                    TransitionInstanceAccessorImpl.this.triggers.clear();
                }
                object = arrayList.iterator();
                while (object.hasNext()) {
                    TriggerableForwarder triggerableForwarder = null;
                    try {
                        triggerableForwarder = (TriggerableForwarder)object.next();
                        triggerableForwarder.proposeSearch();
                    }
                    catch (RemoteException remoteException) {
                        logger.error((Object)("TransitionInstanceAccessor: Search proposal to " + String.valueOf(triggerableForwarder) + " probably got lost due to " + String.valueOf(remoteException)));
                    }
                }
                return null;
            }
        });
        try {
            future.get();
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            logger.error((Object)"Simulation thread threw an exception", (Throwable)executionException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRemoteEventListener(RemoteEventListener remoteEventListener) throws RemoteException {
        Set<RemoteEventListener> set = this.firingListeners;
        synchronized (set) {
            this.firingListeners.remove(remoteEventListener);
            if (this.firingListeners.isEmpty()) {
                ((TransitionInstance)this.object).removeTransitionEventListener((TransitionEventListener)this);
            }
        }
    }

    public TriggerCollection triggers() {
        return this.triggers;
    }

    public boolean wantSynchronousNotification() {
        return false;
    }
}

