/*
 * Decompiled with CFR 0.152.
 */
package de.renew.remote;

import de.renew.application.SimulationEnvironment;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.net.NetElementID;
import de.renew.net.NetInstance;
import de.renew.net.Place;
import de.renew.net.PlaceInstance;
import de.renew.net.Transition;
import de.renew.net.TransitionInstance;
import de.renew.remote.NetAccessor;
import de.renew.remote.NetAccessorImpl;
import de.renew.remote.NetInstanceAccessor;
import de.renew.remote.ObjectAccessorImpl;
import de.renew.remote.PlaceAccessor;
import de.renew.remote.PlaceInstanceAccessor;
import de.renew.remote.PlaceInstanceAccessorImpl;
import de.renew.remote.TransitionInstanceAccessor;
import de.renew.remote.TransitionInstanceAccessorImpl;
import java.rmi.RemoteException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class NetInstanceAccessorImpl
extends ObjectAccessorImpl
implements NetInstanceAccessor {
    public static Logger logger = Logger.getLogger(NetInstanceAccessorImpl.class);

    public NetInstanceAccessorImpl(NetInstance netInstance, SimulationEnvironment simulationEnvironment) throws RemoteException {
        super(netInstance, simulationEnvironment);
    }

    @Override
    public NetAccessor getNet() throws RemoteException {
        Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<NetAccessor>(){

            @Override
            public NetAccessor call() throws Exception {
                return new NetAccessorImpl(((NetInstance)NetInstanceAccessorImpl.this.object).getNet(), NetInstanceAccessorImpl.this.getEnvironment());
            }
        });
        try {
            return (NetAccessor)future.get();
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            logger.error((Object)"Simulation thread threw an exception", (Throwable)executionException);
        }
        return null;
    }

    @Override
    public String getID() throws RemoteException {
        return ((NetInstance)this.object).getID();
    }

    @Override
    public PlaceInstanceAccessor getPlaceInstance(final NetElementID netElementID) throws RemoteException {
        Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<PlaceInstanceAccessor>(){

            @Override
            public PlaceInstanceAccessor call() throws Exception {
                Place place = ((NetInstance)NetInstanceAccessorImpl.this.object).getNet().getPlaceWithID(netElementID);
                if (place == null) {
                    return null;
                }
                PlaceInstance placeInstance = ((NetInstance)NetInstanceAccessorImpl.this.object).getInstance(place);
                if (placeInstance == null) {
                    return null;
                }
                return new PlaceInstanceAccessorImpl(placeInstance, NetInstanceAccessorImpl.this.getEnvironment());
            }
        });
        try {
            return (PlaceInstanceAccessor)future.get();
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            logger.error((Object)"Simulation thread threw an exception", (Throwable)executionException);
        }
        return null;
    }

    @Override
    public TransitionInstanceAccessor getTransitionInstance(final NetElementID netElementID) throws RemoteException {
        Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<TransitionInstanceAccessor>(){

            @Override
            public TransitionInstanceAccessor call() throws Exception {
                Transition transition = ((NetInstance)NetInstanceAccessorImpl.this.object).getNet().getTransitionWithID(netElementID);
                if (transition == null) {
                    return null;
                }
                TransitionInstance transitionInstance = ((NetInstance)NetInstanceAccessorImpl.this.object).getInstance(transition);
                if (transitionInstance == null) {
                    return null;
                }
                return new TransitionInstanceAccessorImpl(transitionInstance, NetInstanceAccessorImpl.this.getEnvironment());
            }
        });
        try {
            return (TransitionInstanceAccessor)future.get();
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            logger.error((Object)"Simulation thread threw an exception", (Throwable)executionException);
        }
        return null;
    }

    PlaceInstanceAccessor getInstance(PlaceAccessor placeAccessor) throws RemoteException {
        return this.getPlaceInstance(placeAccessor.getID());
    }
}

